#!/usr/bin/perl -w
#печать фраз из категорий с разверткой атомов (с форками)

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';
use Data::Dumper;

use Digest::MD5 qw(md5 md5_hex md5_base64);
use Encode;

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

use lib "/home/yuryz/arcadia/rt-research/broadmatching/scripts/lib";

use Utils::Common;
use Project;
use BM::Phrase;
use BM::PhraseList;
use Time::HiRes qw(tv_interval gettimeofday);

my $proj = Project->new({ 
    load_dicts => 1,
    load_minicategs_light => 1,
});

`curl https://catmedia.yandex.ru/acgi-bin/interface/get_categs_tree.pl >ctgs_full_list`; #выдает все категории

my $ctg_count = 0; #####

my $worker = Utils::Worker->new;
$worker->{verbose}    = 1;
$worker->{num_processes}    = 12;

$worker->{file_input}       = "/home/yuryz/scripts/phrs4ctgs/phrs_dupl/ctgs_full_list";
$worker->{file_output}      = "/home/yuryz/scripts/phrs4ctgs/phrs_dupl/phr_ctgs_dupl";

$worker->{process_line}     = sub {
    my ($line, $fh) = @_;
    chomp $line;

    $ctg_count++; #####
    $proj->clog($ctg_count, 'green'); #####

    my ($ind, $id, $id_parent, $ctg) = split /\t/, $line;

    my $ctg_phrs = $proj->phrase($ctg)->get_category_phrases; #список фраз категорий
    my $phr_count = 0; #####

    for my $ctg_phr (@$ctg_phrs) { #свернутые фразы
        $phr_count++; #####
        #$proj->log("$ctg_count\t$phr_count\t$ctg\t$ctg_phr"); #####

        #для сохранения синтаксиса
        $ctg_phr =~ s/\"/%22/g;
        $ctg_phr =~ s/</%3C/g;
        $ctg_phr =~ s/>/%3E/g;
        $ctg_phr =~ s/\{/%7B/g;
        $ctg_phr =~ s/\}/%7D/g;

        my $phr = $proj->phrase($ctg_phr);
        my $phl = $phr->expand_to_phl; #развернутый список фраз

        #$proj->clog(scalar @$phl, 'green'); #####

        for (@$phl) { #развернутые фразы
            s/%22/\"/g;
            s/%3C/</g;
            s/%3E/>/g;
            s/%7B/\{/g;
            s/%7D/\}/g;

            s/^ +//;
            s/ +$//;
            s/  +/ /g;

            print $fh md5_base64(encode_utf8($_)), "\t$id\n";
            #print $fh "$_\t$id\n";
        }
    }
};

$worker->process_data;
