#!/usr/bin/perl -w
#печать фраз из категорий с разверткой именованных атомов

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';
use Data::Dumper;

use Digest::MD5 qw(md5 md5_hex md5_base64);
use Encode;

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

use lib "/home/yuryz/arcadia/rt-research/broadmatching/scripts/lib";
use Project;

my $proj = Project->new({ 
    load_dicts => 1,
    load_minicategs_light => 1,
});

open my $fh, "phrs_ctgs_dup.srt";
my $phr_num = 0; #####

$| = 1; #####
while (my $line = <$fh>) {
    chomp $line;

    my ($ctg_phr, $ctg) = split /\t/, $line;
    next unless $ctg_phr =~ /\[/; #обрабатываем только именованные атомы

    $phr_num++; #####

    #для сохранения синтаксиса
    $ctg_phr =~ s/\"/%22/g;
    $ctg_phr =~ s/</%3C/g;
    $ctg_phr =~ s/>/%3E/g;
    $ctg_phr =~ s/\{/%7B/g;
    $ctg_phr =~ s/\}/%7D/g;

#---------------------------
my $phr_count = 1;
my @fact;
my $atom = "ATOM";
while ($ctg_phr =~ m{(\[[^\]]+\])}g) {
    $atom = $1;
    my $phr = $proj->phrase($atom);
    my $phl = $phr->expand_to_phl; #развернутый список фраз
    $phr_count *= @$phl;
    push @fact, @$phl+0;
}
#if ($phr_count > 1) {
   # print "$phr_count\t[@fact]\t$ctg\t$ctg_phr\n";
#    print "$phr_count\n";
#}
if ($phr_count == 0) {
    print "$atom\n";
}
next;
#---------------------------

    my $phr = $proj->phrase($ctg_phr);
    my $phl = $phr->expand_to_phl; #развернутый список фраз

    $proj->clog(scalar @$phl, 'green'); #####

    for (@$phl) { #развернутые фразы
        s/%22/\"/g;
        s/%3C/</g;
        s/%3E/>/g;
        s/%7B/\{/g;
        s/%7D/\}/g;

        s/^ +//;
        s/ +$//;
        s/  +/ /g;

        print md5_base64(encode_utf8($_)), "\t$id\n";
        #print "$_\t$ctg\n";
    }
}
