#!/usr/bin/perl -w
#корректировка caddphr_web_ru_src для бета-тестирования на основе задания

use strict;

use utf8;
use open ":utf8";
use Data::Dumper;

binmode STDIN, ':utf8';
binmode STDOUT, ':utf8';
binmode STDERR, ':utf8';

my %dict;
open F, "caddphr_web_ru_src"; #исходный словарь для корректировки
while (<F>) {
    chomp;
    my ($ctg, $phrs) = split /\t/;
    $dict{$ctg} = $phrs;
}

while (<STDIN>) { #task.txt
    next if /^#/; #отмена операции
    chomp;

    my ($op, $ctg, $data1, $data2) = split /\t/;
    next unless $dict{$ctg};

    my @phrs = split /,/, $dict{$ctg}; #фразы категории
    if ($op eq "D") { #D - удаление фразы
        for my $i (0..$#phrs) {
            my $phr = $phrs[$i];
            $phr =~ s/^ +//;
            $phr =~ s/ +$//;
            $phr =~ s/  +/ /g;
            if ($phr eq $data1) {
                @phrs = ( @phrs[0..$i-1], @phrs[$i+1..$#phrs] );
                $dict{$ctg} = join(",", @phrs);

                print STDERR "$op\t$ctg\t$data1\n";
                last;
            }
        }
    } elsif ($op eq "C") { #C - изменение фразы
        for my $i (0..$#phrs) {
            my $phr = $phrs[$i];
            $phr =~ s/^ +//;
            $phr =~ s/ +$//;
            $phr =~ s/  +/ /g;
            if ($phr =~ /\Q$data1\E/) {
                $phr =~ s/\Q$data1\E/$data2/;
                @phrs = ( @phrs[0..$i-1], $phr, @phrs[$i+1..$#phrs] );
                $dict{$ctg} = join(",", @phrs);

                print STDERR "$op\t$ctg\t$data1\t=>\t$data2\n";
                last;
            }
        }
    } elsif ($op eq "M") { #M - модификация ВСЕЙ категории
        my $a = $dict{$ctg}; #фразы категории

        if ($data2 ne "*") { # "*" - пустая строка
            $a =~ s/\/?\Q$data1\E/$data2/g; #удаление слеша нужно, чтобы не возникало лишнего "/]" на концах анонимных атомов
        } else {
            $a =~ s/\/?\Q$data1\E//g;
        }

        #устранение возможных "дефектов" форматирования
        $a =~ s{\[\/}{[}g;
        $a =~ s{\/\/}{/}g;
        $a =~ s{\[\]}{ }g;

        $a =~ s/^ +//;
        $a =~ s/ +$//;
        $a =~ s/  +/ /g;

        $a =~ s/ +,/,/g;
        $a =~ s/, +/,/g;

        $a =~ s/\[([^\/\]]+)\]/$1/g; #для вырожденных анонимных атомов типа: [подмосковье] => подмосковье
        $dict{$ctg} = $a;

        print STDERR "$op\t$ctg\t$data1\t=>\t$data2\n";
        last;
    }
}

for (sort keys %dict) {
    print "$_\t$dict{$_}\n";
}
