#!/usr/bin/perl -w
#корректировка категорий

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';
use Data::Dumper;

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");


my %ctgs_diff = ( #категории для определения диффов и оптимизации
    "Андрология" => 1,
    "Урология" => 1,
#    "Электрические кабели, провода и шнуры" => 1,
);

my %dict; #словарь для корректировки
open F, "caddphr_web_ru_src";
while (<F>) {
    chomp;

    my ($ctg, $phr_lst) = split /\t/; #категория, список фраз (comma-delimited)
    $dict{$ctg} = $phr_lst;

    $ctgs_diff{$ctg} = $phr_lst if $ctgs_diff{$ctg}; #категории для определения диффов
}

my $cnt = 0; #####
while (<STDIN>) { #dup_andr_urol_942, dup_pol_cabel_832
    <STDIN>; #дубли идут парами
    chomp;

    my ($phr, $ctg, $id, $num) = split /\t/; #фраза-дубль, категория, ID категории, номер фразы в категории
    my $ctg_corr = $phr =~ /(цистит|уретрит|хламидиоз|Эписпадия|уреаплазмоз)/ ? "Андрология" : "Урология"; #категория для корректировки
#    $ctg_corr = "Электрические кабели, провода и шнуры";

    $cnt++; #####
    print STDERR "***[$cnt]\t$phr\t$ctg\n\n"; #####

    phr_del($ctg_corr, $phr); #удаление фразы из категории
}

for my $ctg_diff (sort keys %ctgs_diff) { #ОПТИМИЗАЦИИЯ ФРАЗ в категориях
    phr_opt($ctg_diff); #изменяет словарь %dict
}

open F, ">caddphr_web_ru_942"; #новая версия словаря
for (sort keys %dict) {
    print F "$_\t$dict{$_}\n";
}

#--- ДИФФЫ ---
for my $ctg_diff (sort keys %ctgs_diff) {
    my @before = split /,/, $ctgs_diff{$ctg_diff};
    my %before;
    for (@before) {
        $before{$_} = 1;
    }

    my @after = split /,/, $dict{$ctg_diff};
    my %after;
    for (@after) {
        $after{$_} = 1;
    }

    print STDERR "\nКАТЕГОРИЯ $ctg_diff: отличие ДО от ПОСЛЕ\n\n";
    for (sort keys %before) {
        print STDERR "$_\n\n" unless $after{$_};
    }
    print STDERR "\nКАТЕГОРИЯ $ctg_diff: отличие ПОСЛЕ от ДО\n\n";
    for (sort keys %after) {
        print STDERR "$_\n\n" unless $before{$_};
    }
}


#--- удаление фразы из категории ---
sub phr_del {
    my ($ctg, $phr_del) = @_;

    my $phr_lst = $dict{$ctg}; #список фраз (comma-delimited)
    my @phrs = split /,/, $phr_lst;

    for my $phr (@phrs) {
        #проверка и исправление синтаксиса
        if ($phr =~ /((?<=[^ ])([\[\{])|([\]\}])(?=[^ ]))/ || $phr =~ /((?<=[^ \/\[-])<|>(?=[^ \/\]]))/) { #синтаксическая ошибка - нет ' ' слева от '[{' или справа от ']}' ИЛИ нет ' /[-' слева от '<' или ' /]' справа от '>'
            $phr =~ s/(?<=[^ ])([\[\{])/ $1/g; #вставка пробела слева от '[{'
            $phr =~ s/([\]\}])(?=[^ ])/$1 /g; #вставка пробела справа от ']}'

            $phr =~ s/(?<=[^ \/\[-])</ </g; #вставка пробела слева от '<'
            $phr =~ s/>(?=[^ \/\]])/> /g; #вставка пробела справа от '>'
        }
        $phr =~ s{\\}{\/}g if $phr =~ m{\\};

        my @wrds = phr_parse($phr); # массив "слов" фразы

        my @wrds_comb; # массив всевозможных комбинаций "слов" фразы (ПРОСТЫЕ фразы)
        my $wrd_pos = 0; # позиция "слова" во фразе
        for my $i (0..$#wrds) {
            my $wrd = $wrds[$i];
            $wrd_pos++;
            my @tmp;
            if ($wrd =~ /^\[/) { #атом
                $wrd =~ s/^\[//;
                $wrd =~ s/\]$//;
                $wrd =~ s/^ +//;
                $wrd =~ s/ +$//;
                for (split m{/}, $wrd) {
                    s/^ +//;
                    s/ +$//;
                    $_ = "[$_]" if /^(hier)?\./; #именованный атом
                    push @tmp, "$wrd_pos\t$_";
                }
                push @tmp, "$wrd_pos\t" if $wrd =~ m{/$};
            } else { #не атом
                push @tmp, "$wrd_pos\t$wrd";
            }
            @wrds_comb = cart_prod_pos(\@wrds_comb, \@tmp);
        }

        for my $wrds_comb (@wrds_comb) { #ПОИСК фразы для удаления
            my @phr_atom; #собранная из анонимных атомов ПРОСТАЯ фраза

            my @a = split /\t/, $wrds_comb;
            for (my $j = 1; $j <= $#a; $j += 2) { #на НЕЧЕТНЫХ местах находятся "слова" (а на четных - номера)
                push @phr_atom, $a[$j];
            }

            my $phr_atom = join(" ", @phr_atom);
            $phr_atom =~ s/^ +//;
            $phr_atom =~ s/ +$//;
            $phr_atom =~ s/  +/ /g;

            $phr_atom = join(" ", sort split(/ +/, $phr_atom)); #не учитываем порядок слов
            $phr_del = join(" ", sort split(/ +/, $phr_del));

            if ($phr_del eq $phr_atom) { #ПРОСТАЯ фраза для удаления найдена, корректируем ИСХОДНУЮ фразу
                print STDERR "^$phr\n\n"; #####
                print STDERR "=$wrds_comb\n\n"; #####
                $phr = join(",", phr_corr(\@wrds, \@a)); #ВНОСИМ ИЗМЕНЕНИЯ в массив @phrs
            }
        }

        $phr_lst = join(",", @phrs);
        $phr_lst =~ s/,,/,/g; #удаление ПУСТЫХ фраз

        $dict{$ctg} = $phr_lst; #ВНОСИМ ИЗМЕНЕНИЯ в словарь caddphr_web_ru
    }
}


#--- парсинг строки с фразами ---
sub phr_parse {
    my ($phr) = @_;

    my @wrds; # массив слов и словосочетаний фразы
    while ($phr =~ m!(\[[^\]]+\]|<[^>]+>|\{[^\}]+\}|[^ ]+(?= |$))!g) { #[.Производители техники/Разработчики/] led-телевизор [samsung/loewe/philips/toshiba/hitachi/orion/grundig/lg] <плеер pioneer> dv {Супермаркеты электроники и бытовой техники} 610 av
        push @wrds, $1;
    }

    return @wrds;
}


#--- декартово произведение двух множеств ---
sub cart_prod_pos {
    my ($a, $b) = @_;

    my @prod;
    $$a[0] = "" unless @$a;
    for my $a (@$a) {
        if (@$b > 1) {
            my $atm_pos = 0; # позиция "атома" в "слове"
            for (@$b) {
                $atm_pos++;
                my ($wrd_pos, $wrd) = split /\t/; #позиция "слова" во фразе
                my $tmp = "$wrd_pos,$atm_pos\t$wrd";
                push @prod, $a ? "$a\t$tmp" : $tmp;
            }
        } else {
            push @prod, $a ? "$a\t$$b[0]" : $$b[0];
        }
    }

    return @prod;
}


#--- корректировка фразы ---
sub phr_corr {
    my ($wrds, $a) = @_; #массив "слов" исходной фразы; массив слов удаляемой фразы с номерами позиций (см. cart_prod_pos())

    my @wrds = @$wrds;
    my @a = @$a;

    my @phrs_res; #РЕЗУЛЬТАТ КОРРЕКТИРОВКИ
    my $i = -1; #индекс "слова" в ИСХОДНОМ массиве @wrds
    for (my $j = 0; $j <= $#a; $j += 2) { #на ЧЕТНЫХ местах находятся номера (а на нечетных - "слова")
        $i++;
        if ($wrds[$i] =~ /^\[/) { #анонимный атом
            if ($a[$j] =~ /,/) {
                $a[$j] =~ s/^.*,//; #оставляем число после запятой - позицию "атома" в "слове" (см. cart_prod_pos())
            } else {
                $a[$j] = 1;
            }
            my $k = $a[$j] - 1; #индекс УДАЛЯЕМОГО слова в анонимном атоме

            my $wrd = $wrds[$i];
            $wrd =~ s/^\[//;
            $wrd =~ s/\]$//;
            $wrd =~ s/^ +//;
            $wrd =~ s/ +$//;

            my @wrd = split m{/}, $wrd;
            push @wrd, "" if $wrd =~ m{/$};

            my $atom = join("/", (@wrd[0..$k-1], @wrd[$k+1..$#wrd])); #атом БЕЗ удаленного слова
            $atom = "[".$atom."]" if $atom =~ m{/} || $atom =~ m{^\.};

            my $phrs_res = join(" ", (@wrds[0..$i-1], $atom, @wrds[$i+1..$#wrds]));
            $phrs_res =~ s/  +/ /g;
            push @phrs_res, $phrs_res if $atom || @wrd > 1;

            $wrd[$k] = "[".$wrd[$k]."]" if $wrd[$k] =~ /^\./;
            $wrds[$i] = $wrd[$k]; #удаленное "слово"
        }
    }

    return @phrs_res;
}

########################################################

#--- оптимизациия фраз в категории ---
sub phr_opt {
    my ($ctg) = @_;

    my $flag = 1;
    my $phr_lst = $dict{$ctg}; #список фраз (comma-delimited)
    my @phrs = split /,/, $phr_lst;

    for (@phrs) { #чистка
        s/^ +//;
        s/ +$//;
        s/  +/ /g;
    }

    for my $i (0..$#phrs) {
        next if $phrs[$i] =~ /^\*/; #фраза $phrs[$i] уже включена в какую-то фразу
        my @wrdsI = phr_wrds($phrs[$i]); #получение списка "слов" фразы
        for my $j (0..$#phrs) {
            next if $i == $j;
            next if $phrs[$j] =~ /^\*/; #фраза $phrs[$j] уже включена в какую-то фразу
            my @wrdsJ = phr_wrds($phrs[$j]);

            if (phrs_incl(\@wrdsI, \@wrdsJ)) { #фраза $phrs[$j] входит в $phrs[$i]
                if ($flag == 1) {
                    $flag = 0;
                    print "\n*КАТЕГОРИЯ: '$ctg'\n\n"; #категория
                }
                print "$i\t$phrs[$i]\n";
                print "$j\t$phrs[$j]\n";
                print "--\n";

                $phrs[$j] = "*$phrs[$j]";
            }
        }
    }

    my @tmp;
    for (@phrs) { #фильтр более мелких подфраз
        push @tmp, $_ unless /^\*/;
    }
 
    $dict{$ctg} = join(",", @tmp); #ВНОСИМ ИЗМЕНЕНИЯ в словарь caddphr_web_ru
}


#--- тест на включение фразы @b во фразу @a ---
sub phrs_incl {
    my ($a, $b) = @_; #списки "слов" (массивы) сравниваемых фраз

    my @a = del_com($a, $b); #удаление из @$a элементов, общих с @$b
    my @b = del_com($b, $a);

    my @a_comb = wrds_comb(\@a); #генерация массива простых фраз
    my @b_comb = wrds_comb(\@b);

    @a_comb = ("") unless @a_comb;
    @b_comb = ("") unless @b_comb;

    my %h;
    $h{$_} = 1 for @a_comb;
    for (@b_comb) {
        return 0 unless $h{$_};
    }
    return 1;
}


#--- удаление из массива @a элементов, общих с @b (с учетом количества) ---
sub del_com {
    my ($a, $b) = @_;

    my %h;
    $h{$_}++ for @$b;

    my @a;
    for (@$a) {
        unless ($h{$_}) {
            push @a, $_;
        } else {
            $h{$_}--;
            delete $h{$_} if $h{$_} == 0;
        }
    }

    return @a;
}


#--- получение полного списка простых фраз для фразы ---
sub wrds_comb {
    my ($wrds) = @_; #список "слов" фразы

    my @wrds_comb; # массив всевозможных комбинаций слов и словосочетаний фразы
    for my $wrd (@$wrds) {
        my @tmp;
        if ($wrd =~ /^\[/) { #атом
            $wrd =~ s/^\[//;
            $wrd =~ s/\]$//;
            $wrd =~ s/^ +//;
            $wrd =~ s/ +$//;
            @tmp = split m{/}, $wrd;
            push @tmp, "" if $wrd =~ m{/$};
        } else { #не атом
            push @tmp, $wrd;
        }
        @wrds_comb = cart_prod(\@wrds_comb, \@tmp);
    }

    for my $wrds_comb (@wrds_comb) {
        $wrds_comb =~ s/^ +//;
        $wrds_comb =~ s/ +$//;
        $wrds_comb =~ s/  +/ /g;

        $wrds_comb = join(" ", sort (phr_wrds($wrds_comb)));
    }

    return @wrds_comb;
}


#--- получение списка "слов" фразы ---
sub phr_wrds {
    my ($phr) = @_;

    #проверка и исправление синтаксиса
    if ($phr =~ /((?<=[^ ])([\[\{])|([\]\}])(?=[^ ]))/ || $phr =~ /((?<=[^ \/\[-])<|>(?=[^ \/\]]))/) { #синтаксическая ошибка - нет ' ' слева от '[{' или справа от ']}' ИЛИ нет ' /[-' слева от '<' или ' /]' справа от '>'
        $phr =~ s/(?<=[^ ])([\[\{])/ $1/g; #вставка пробела слева от '[{'
        $phr =~ s/([\]\}])(?=[^ ])/$1 /g; #вставка пробела справа от ']}'

        $phr =~ s/(?<=[^ \/\[-])</ </g; #вставка пробела слева от '<'
        $phr =~ s/>(?=[^ \/\]])/> /g; #вставка пробела справа от '>'
    }
    $phr =~ s{\\}{\/}g if $phr =~ m{\\};

    return phr_parse($phr); #список "слов" фразы
}


#--- декартово произведение двух множеств ---
sub cart_prod {
    my ($a, $b, $DEL) = @_;
    $DEL = " " unless $DEL; #разделитель "слов"

    my @prod;
    unless (@$a) {
        @prod = @$b; 
    } else {
        for my $a (@$a) {
            push @prod, $a ? "$a$DEL$_" : $_ for @$b;
        }
    }

    return @prod;
}
