#!/usr/bin/perl -w
#оптимизация фраз в категориях

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';
use Data::Dumper;

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");


while (<STDIN>) { #caddphr_web_ru_src
    chomp;

    my ($ctg, $phr_lst) = split /\t/; #категория, список фраз (comma-delimited)
#next if $ctg eq "Вино";
#print STDERR "***$ctg\n";
    my @phr_lst = phr_opt($ctg, $phr_lst); #оптимизациия фраз в категории

    print "$ctg\t".join(",", @phr_lst)."\n";
}


#--- оптимизациия фраз в категории ---
sub phr_opt {
    my ($ctg, $phr_lst) = @_;

    my @phrs = split /,/, $phr_lst;
    for (@phrs) { #чистка
        s/^ +//;
        s/ +$//;
        s/  +/ /g;
    }

    my $flag = 1;
    for my $i (0..$#phrs) {
        next if $phrs[$i] =~ /^\*/; #фраза $phrs[$i] уже включена в какую-то фразу
        my @wrdsI = phr_wrds($phrs[$i]); #получение списка "слов" фразы
        for my $j (0..$#phrs) {
            next if $i == $j;
            next if $phrs[$j] =~ /^\*/; #фраза $phrs[$j] уже включена в какую-то фразу
            my @wrdsJ = phr_wrds($phrs[$j]);

#-----------------------------------------------------
next unless nec_cond(\@wrdsI, \@wrdsJ); #проверка необходимого условия вхождения
#-----------------------------------------------------

            if (phrs_incl(\@wrdsI, \@wrdsJ)) { #фраза $phrs[$j] входит в $phrs[$i]
                if ($flag == 1) {
                    $flag = 0;
                    print STDERR "\n*КАТЕГОРИЯ: '$ctg'\n\n"; #категория
                }
                print STDERR "$i\t$phrs[$i]\n";
                print STDERR "$j\t$phrs[$j]\n";
                print STDERR "--\n";

                $phrs[$j] = "*$phrs[$j]";
            }
        }
    }

    my @tmp;
    for (@phrs) { #фильтр более мелких подфраз
        push @tmp, $_ unless /^\*/;
    }
 
    my @phrs_num = split(/,/, $phr_lst); #исходное число фраз
    if ($flag == 0) { #были удаления фраз
        print STDERR "ЧИСЛО ФРАЗ: ДО=", @phrs_num+0, ", ПОСЛЕ=", @tmp+0, "\n";
    }

    return @tmp;
}


# --- необходимое условие вхождения одной фразы в другую ---
sub nec_cond {
    my ($a, $b) = @_; #списки "слов" (массивы) сравниваемых фраз

    my @a = del_com($a, $b); #удаление из @$a элементов, общих с @$b
    my @b = del_com($b, $a);

    @a = ("") unless @a; ############
    @b = ("") unless @b; ############

    my %hash; #отображение "слов" фразы @a в "слова" фразы @b
    for my $i (0..$#a) {
        my $key = $i + 1;
        for my $j (0..$#b) {
            if (wrds_incl($a[$i], $b[$j])) { #"слово" $a[$i] входит в слово $b[$j]
                my $value = $j + 1;
                push @{$hash{$key}}, $value;
            }
        }
    }
    return 0 if scalar keys %hash < @a; #"слова" @b не покрывают @a

    my @num_comb;
    for (sort keys %hash) { #####
        @num_comb = cart_prod(\@num_comb, \@{$hash{$_}}); #номера слов @b, ВОЗМОЖНО покрывающие @a
    }

    my $hom = 0; #число однородных атомов
    my %n;
    for my $nums (@num_comb) {
        my @n = split / /, $nums;
        %n = ();
        $n{$_}++ for @n; #распознанные РАЗНЫЕ номера
        next if scalar keys %n < @a; #ДАННАЯ комбинация "слов" @b не покрывают @a

        $hom = 0; #число однородных атомов среди "слов" @b, не участвующих в покрытии
        for my $i (0..$#b) {
            my $key = $i + 1;
            next if $n{$key};
            $hom++ unless $b[$i] =~ m{\/\]};
        }
        last if $hom == 0;
    }
    return 0 if scalar keys %n < @a; #"слова" фразы @b не покрывают фразу @a
    return 0 if $hom; #однородные атомы @b не позволяют выполнить покрытие @a

    return 1;
}


#--- проверка вхождения "слова" $a в слово $b ---
sub wrds_incl {
    my ($a, $b) = @_; #"слова" из разных фраз

    $a =~ s/^\[//;
    $a =~ s/\]$//;
    $a =~ s/^ +//;
    $a =~ s/ +$//;
    my @a = split m{/}, $a;
    push @a, "" if $a =~ m{/$};

    $b =~ s/^\[//;
    $b =~ s/\]$//;
    $b =~ s/^ +//;
    $b =~ s/ +$//;
    my @b = split m{/}, $b;
    push @b, "" if $a =~ m{/$};

    @a = ("") unless @a; ############
    @b = ("") unless @b; ############

    my %h;
    $h{$_} = 1 for @b;
    for (@a) {
        return 0 unless $h{$_};
    }
    return 1;
}


#--- тест на включение фразы @b во фразу @a ---
sub phrs_incl {
    my ($a, $b) = @_; #списки "слов" (массивы) сравниваемых фраз

    my @a = del_com($a, $b); #удаление из @$a элементов, общих с @$b
    my @b = del_com($b, $a);

    my @a_comb = wrds_comb(\@a); #генерация массива простых фраз
    my @b_comb = wrds_comb(\@b);

    @a_comb = ("") unless @a_comb;
    @b_comb = ("") unless @b_comb;

    my %h;
    $h{$_} = 1 for @a_comb;
    for (@b_comb) {
        return 0 unless $h{$_};
    }
    return 1;
}


#--- удаление из массива @a элементов, общих с @b (с учетом количества) ---
sub del_com {
    my ($a, $b) = @_;

    my %h;
    $h{$_}++ for @$b;

    my @a;
    for (@$a) {
        unless ($h{$_}) {
            push @a, $_;
        } else {
            $h{$_}--;
            delete $h{$_} if $h{$_} == 0;
        }
    }

    return @a;
}


#--- получение полного списка простых фраз для фразы ---
sub wrds_comb {
    my ($wrds) = @_; #список "слов" фразы

    my @wrds_comb; # массив всевозможных комбинаций слов и словосочетаний фразы
    for my $wrd (@$wrds) {
        my @tmp;
        if ($wrd =~ /^\[/) { #атом
            $wrd =~ s/^\[//;
            $wrd =~ s/\]$//;
            $wrd =~ s/^ +//;
            $wrd =~ s/ +$//;
            @tmp = split m{/}, $wrd;
            push @tmp, "" if $wrd =~ m{/$};
        } else { #не атом
            push @tmp, $wrd;
        }
        @wrds_comb = cart_prod(\@wrds_comb, \@tmp);
    }

    for my $wrds_comb (@wrds_comb) {
        $wrds_comb =~ s/^ +//;
        $wrds_comb =~ s/ +$//;
        $wrds_comb =~ s/  +/ /g;

        $wrds_comb = join(" ", sort (phr_wrds($wrds_comb)));
    }

    return @wrds_comb;
}


#--- получение списка "слов" фразы ---
sub phr_wrds {
    my ($phr) = @_;

    #проверка и исправление синтаксиса
    if ($phr =~ /((?<=[^ ])([\[\{])|([\]\}])(?=[^ ]))/ || $phr =~ /((?<=[^ \/\[-])<|>(?=[^ \/\]]))/) { #синтаксическая ошибка - нет ' ' слева от '[{' или справа от ']}' ИЛИ нет ' /[-' слева от '<' или ' /]' справа от '>'
        $phr =~ s/(?<=[^ ])([\[\{])/ $1/g; #вставка пробела слева от '[{'
        $phr =~ s/([\]\}])(?=[^ ])/$1 /g; #вставка пробела справа от ']}'

        $phr =~ s/(?<=[^ \/\[-])</ </g; #вставка пробела слева от '<'
        $phr =~ s/>(?=[^ \/\]])/> /g; #вставка пробела справа от '>'
    }
    $phr =~ s{\\}{\/}g if $phr =~ m{\\};

    return phr_parse($phr); #список "слов" фразы
}


#--- парсинг строки с фразами ---
sub phr_parse {
    my ($phr) = @_;

    my @wrds; # массив слов и словосочетаний фразы
    while ($phr =~ m!(\[[^\]]+\]|<[^>]+>|\{[^\}]+\}|[^ ]+(?= |$))!g) { #[.Производители техники/Разработчики/] led-телевизор [samsung/loewe/philips/toshiba/hitachi/orion/grundig/lg] <плеер pioneer> dv {Супермаркеты электроники и бытовой техники} 610 av
        push @wrds, $1;
    }

    return @wrds;
}


#--- декартово произведение двух множеств ---
sub cart_prod {
    my ($a, $b, $DEL) = @_;
    $DEL = " " unless $DEL; #разделитель "слов"

    my @prod;
    unless (@$a) {
        @prod = @$b; 
    } else {
        for my $a (@$a) {
            push @prod, $a ? "$a$DEL$_" : $_ for @$b;
        }
    }

    return @prod;
}
