#!/usr/bin/perl -w
#развертка и свертка анонимных атомов

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';
use Data::Dumper;

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");


while (<STDIN>) { #caddphr_web_ru
    chomp;

    my ($ctg, $phr_lst) = split /\t/; #категория, список фраз (comma-delimited)
    my @phrs = split /,/, $phr_lst;

    print "$ctg\n"; #***КАТЕГОРИЯ 
    for my $phr (@phrs) {
        print "\t$phr\n" if $phr =~ /\[/; #***ФРАЗА 
        #проверка и исправление синтаксиса
        if ($phr =~ /((?<=[^ ])([\[\{])|([\]\}])(?=[^ ]))/ || $phr =~ /((?<=[^ \/\[-])<|>(?=[^ \/\]]))/) { #синтаксическая ошибка - нет ' ' слева от '[{' или справа от ']}' ИЛИ нет ' /[-' слева от '<' или ' /]' справа от '>'
            $phr =~ s/(?<=[^ ])([\[\{])/ $1/g; #вставка пробела слева от '[{'
            $phr =~ s/([\]\}])(?=[^ ])/$1 /g; #вставка пробела справа от ']}'

            $phr =~ s/(?<=[^ \/\[-])</ </g; #вставка пробела слева от '<'
            $phr =~ s/>(?=[^ \/\]])/> /g; #вставка пробела справа от '>'
        }
        $phr =~ s{\\}{\/}g if $phr =~ m{\\};

        my @wrds = phr_parse($phr); # массив слов и словосочетаний фразы

        my @wrds_comb; # массив всевозможных комбинаций слов и словосочетаний фразы
        my $wrd_pos = 0; # позиция "слова" во фразе
        for my $wrd (@wrds) {
            $wrd_pos++;
            my @tmp;
            if ($wrd =~ /^\[/) { #атом
                $wrd =~ s/^\[//;
                $wrd =~ s/\]$//;
                $wrd =~ s/^ +//;
                $wrd =~ s/ +$//;
                for (split m{/}, $wrd) {
                    s/^ +//;
                    s/ +$//;
                    $_ = "[$_]" if /^(hier)?\./; #именованный атом
                    push @tmp, "$wrd_pos\t$_";
                }
                push @tmp, "$wrd_pos\t" if $wrd =~ m{/$};
            } else { #не атом
                push @tmp, "$wrd_pos\t$wrd";
            }
            @wrds_comb = cart_prod(\@wrds_comb, \@tmp);
        }

        for my $wrds_comb (@wrds_comb) {
            $wrds_comb =~ s/^ +//;
            $wrds_comb =~ s/ +$//;
            $wrds_comb =~ s/  +/ /g;
            print "\t\t$wrds_comb\n" if @wrds_comb > 1; #***РАЗВЕРНУТАЯ ФРАЗА
        }
    }
}


#--- парсинг строки с фразами ---
sub phr_parse {
    my ($phr) = @_;

    my @wrds; # массив слов и словосочетаний фразы
    while ($phr =~ m!(\[[^\]]+\]|<[^>]+>|\{[^\}]+\}|[^ ]+(?= |$))!g) { #[.Производители техники/Разработчики/] led-телевизор [samsung/loewe/philips/toshiba/hitachi/orion/grundig/lg] <плеер pioneer> dv {Супермаркеты электроники и бытовой техники} 610 av
        push @wrds, $1;
    }

    return @wrds;
}


#--- декартово произведение двух множеств ---
sub cart_prod {
    my ($a, $b) = @_;

    my @prod;
    $$a[0] = "" unless @$a;
    for my $a (@$a) {
        if (@$b > 1) {
            my $atm_pos = 0; # позиция "атома" в "слове"
            for (@$b) {
                $atm_pos++;
                my ($wrd_pos, $wrd) = split /\t/;
                my $tmp = "$wrd_pos,$atm_pos\t$wrd";
                push @prod, $a ? "$a\t$tmp" : $tmp;
            }
        } else {
            push @prod, $a ? "$a\t$$b[0]" : $$b[0];
        }
    }

    return @prod;
}
