#!/usr/bin/python
# -*- coding: utf-8 -*-

import yt.wrapper as yt


def mapper(rec):
    yield {'url': rec['TargetUrl'], 'text': rec['Text']}


def main():
    input = '//home/webmaster/prod/export/catalogia/links'
    output = '//home/catalogia/yuryz/links'

    yt.run_map(mapper, input, output)
    yt.run_sort(output, sort_by='url')

    print yt.row_count(input)
    print yt.row_count(output)


if __name__ == '__main__':
    main()
