#!/usr/bin/perl -w
#печать дублей из разных категорий

use strict;

use utf8;
use open ":utf8";
use Data::Dumper;

binmode STDIN, ':utf8';
binmode STDOUT, ':utf8';
binmode STDERR, ':utf8';


my %ctgs;
open F, "ctgs_full_list";
while (<F>) {
    chomp;
    my ($ind, $id, $id_parent, $name) = split /\t/;
    $ctgs{$id} = $name;
}

#--- блок записей для анализа ---
my @key; #<ключ> (см. select4expand.pl и unorder_dupl.pl)
my @phr; #<фраза>
my @id; #<ID категории>
my @num; #<номер фразы в категории>

my $rec_count = 0; #####
while (my $rec = <STDIN>) { #phrs_ctgs_dup
    $rec_count++; #####
    print STDERR "$rec_count\n" if $rec_count % 10000 == 0; #####

    chomp $rec;
    my ($key, $phr, $id, $num) = split /\t/, $rec; #<ключ>, <фраза>, <ID категории>, <номер фразы в категории>

    my $ret = add_to_block($key, $phr, $id, $num); #добавление записи к блоку
    block_proc($key, $phr, $id, $num) unless $ret; #обработка блока
}
block_proc("", "", "", "");


#--- добавление записей к блоку ---
sub add_to_block {
    my ($key, $phr, $id, $num) = @_;

    if (@key == 0 || $key[0] eq $key) {
        push @key, $key;
        push @phr, $phr;
        push @id, $id;
        push @num, $num;
        return 1;
    }
    return 0;
}


#--- обработка блока ---
sub block_proc {
    my ($key, $phr, $id, $num) = @_;

    if (@key > 1) {
        my %id;
        for my $i (0..$#key) { #проверка разнообразия категорий
            $id{$id[$i]} = 1;
        }

        if (keys %id > 1) { #в блоке категорий > 1
            %id = ();
            for my $i (0..$#key) {
                unless ($id{$id[$i]}) { #выводим каждую категорию по 1 разу
                    print "$phr[$i]\t$ctgs{$id[$i]}\t$id[$i]\t$num[$i]\n";
                    $id{$id[$i]} = 1;
                }
            }
        }
    }

    #новый блок
    @key = ($key);
    @phr = ($phr);
    @id = ($id);
    @num = ($num);
}
