#!/usr/bin/perl -w
#отбор записей с атомами для развертки

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';
use Data::Dumper;

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

use lib "/home/yuryz/arcadia/rt-research/broadmatching/scripts/lib";
use Project;

my $proj = Project->new({ 
    load_dicts => 1,
    load_minicategs_light => 1,
});


my %natoms; #именованные атомы
open F, "named_atoms"; #результаты phr_ctgs_expand1.pl
while (<F>) {
    chomp;
    my ($atom, $size) = split /\t/; #атом, количество_элементов
    my @phl = atom_named_exp($atom); #фразы атомов

    $natoms{"[$atom]"} = \@phl;
    for (@phl) { #фразы атомов
        $natoms{$_}{"[$atom]"} = 1; #для проверки вхождения
    }

    $proj->clog("$atom\t".(@phl+0), 'green'); #####
}

my %across; #пересечение атомов
open F, "atoms_cross"; #результаты atoms_cross.pl
while (<F>) {
    chomp;
    my ($atom1, $atom2, $word) = split /\t/; #атом1, атом2, общее слово
    push @{$across{"[$atom1]\t[$atom2]"}}, $word;
}

#--- блок записей для анализа ---
my @sign; #<сигнатура>
my @phr; #<фраза>
my @ctg; #<ID категории>
my @num; #<номер фразы в категории>

my $rec_count = 0; #####
while (my $rec = <STDIN>) { #phrs_ctgs_dup.dir2 (результаты words_in_atom.pl - с лексическими сигнатурами)
    $rec_count++; #####
    $proj->clog($rec_count, 'green') if $rec_count % 10000 == 0; #####

    chomp $rec;

    my ($sign, $phr, $ctg, $num) = split /\t/, $rec; #<сигнатура>, <фраза>, <ID категории>, <номер фразы в категории>

    my $ret = add_to_block($sign, $phr, $ctg, $num); #добавление записи к блоку
    block_proc($sign, $phr, $ctg, $num) unless $ret; #обработка блока
    
}
block_proc("", "", "", "");


#--- добавление записей к блоку ---
sub add_to_block {
    my ($sign, $phr, $ctg, $num) = @_;

    if (@sign == 0 || $sign[0] eq $sign) {
        push @sign, $sign;
        push @phr, $phr;
        push @ctg, $ctg;
        push @num, $num;
        return 1;
    }
    return 0;
}


#--- обработка блока ---
sub block_proc {
    my ($sign, $phr, $ctg, $num) = @_;

    if (@sign > 1) {
        for my $i (0..$#sign) {
            if ($phr[$i] =~ /\[/) { #во фразе есть атом
                for my $j (0..$#sign) {
                    next if $ctg[$i] eq $ctg[$j];

                    my @conj = conj($phr[$i], $phr[$j]); #обобщенная "конъюнкция" двух фраз (bag of words) - может быть НЕСКОЛЬКО вариантов
                    if (@conj) { #истинность "конъюнкции" ГАРАНТИРУЕТ хотя бы один дубль
                        for my $conj (@conj) {
                            my @numsIJ = split / /, $conj; #последовательность номеров слов фразы J, с которыми попарно сравниваются слова фразы I

                            my @wds1 = phr_parse($phr[$i]); #слова фразы
                            my @wds2 = phr_parse($phr[$j]);

                            my @dupl; # массив всевозможных ключей для поиска дублей
                            for my $k (0..$#numsIJ) {
                                my @tmp;
                                if ($wds1[$k] =~ /^\[/ && $wds2[$numsIJ[$k]-1] =~ /^\[/) { #оба слова - атомы
                                    if ($wds1[$k] eq $wds2[$numsIJ[$k]-1]) { #атомы совпадают полностью
                                        push @tmp, @{$natoms{"$wds1[$k]"}};
                                        #push @tmp, $wds1[$k]; #при частичной развертке дублей
                                    } else { #атомы совпадают частично
                                        push @tmp, @{$across{"$wds1[$k]\t$wds2[$numsIJ[$k]-1]"}};
                                    }
                                } elsif ($wds1[$k] =~ /^\[/) {
                                    push @tmp, $wds2[$numsIJ[$k]-1]; #слово
                                } elsif ($wds2[$numsIJ[$k]-1] =~ /^\[/) {
                                    push @tmp, $wds1[$k];
                                } else { #оба слова - не атомы
                                    push @tmp, $wds1[$k];
                                }
                                @dupl = cart_prod(\@dupl, \@tmp, "\t"); #используем "\t" в качестве разделителя, т.к. атомы могут содержать фразы из нескольких слов
                            }

                            for (@dupl) {
                                s/^ +//;
                                s/ +$//;
                                s/  +/ /g;

                                my @wds = split /\t/; # слова фразы-дубля (используем "\t" в качестве разделителя) (т.к. атомы могут содержать фразы из нескольких слов)

                                my @key = map { lc($_) } @wds;
                                my $key = join(" ", @key);

                                ######################
                                @key = phr_parse($key); #т.к. атомы могут содержать фразы из нескольких слов
                                $key = join(" ", sort @key); # *** добавляем неупорядоченность
                                ######################

                                my $phrI = join(" ", @wds); #во фразе phr[$i] порядок слов не менялся
                                print "$key\t$phrI\t$ctg[$i]\t$num[$i]\n";

                                my $phrJ = "";
                                for my $k (0..$#numsIJ) { #восстановление порядка слов во фразе phr[$j]
                                    $phrJ = "$phrJ " if $k > 0;
                                    $phrJ .= $wds[$numsIJ[$k]-1];
                                }
                                print "$key\t$phrJ\t$ctg[$j]\t$num[$j]\n";
                            }
                        }
                    }
                }
            }
        }
    }

    #новый блок
    @sign = ($sign);
    @phr = ($phr);
    @ctg = ($ctg);
    @num = ($num);
}


#--- обобщенная "конъюнкция" двух фраз (bag of words) ---
sub conj {
    my ($a, $b) = @_; #фразы

    my @a = phr_parse($a); #слова фразы
    my @b = phr_parse($b);
    return 0 if @a * @b == 0 || @a != @b;

    my @conj; #массив всевозможных попарных конъюнкций между словами фраз
    for my $i (0..$#a) {
        my @tmp;
        for my $j (0..$#b) {
            if ($a[$i] =~ /^\[/ && $b[$j] =~ /^\[/) { #оба слова - атомы
                if ($a[$i] eq $b[$j] || $across{"$a[$i]\t$b[$j]"}) { #атомы совпадают или пересекаются
                    push @tmp, $j+1; #номер слова во второй фразе
                    next;
                }
            } elsif ($a[$i] =~ /^\[/) { #первое слово - атом
                if ($natoms{$b[$j]}{$a[$i]}) { #слово $b[$j] входит в атом $a[$i]
                    push @tmp, $j+1;
                    next;
                }
            } elsif ($b[$j] =~ /^\[/) { #второе слово - атом
                if ($natoms{$a[$i]}{$b[$j]}) { #слово $a[$i] входит в атом $b[$j]
                    push @tmp, $j+1;
                    next;
                }
            } else { #оба слова - не атомы
                if ($a[$i] eq $b[$j]) {
                    push @tmp, $j+1;
                    next;
                }
            }
        }
        return () unless @tmp;
        @conj = cart_prod(\@conj, \@tmp);
    }

    my @conj_corr;
    for my $conj (@conj) { #фильтрация ненужных комбинаций
        my %n;
        my @n = split / /, $conj;
        map { $n{$_} = 1 } @n;
        push @conj_corr, $conj if keys(%n) == @a; #конъюнкция должна быть ПЕРЕСТАНОВКОЙ слов фразы (т.е. не содержать ПОВТОРОВ номеров слов)
    }

    return @conj_corr;
}


#--- парсинг строки с фразами ---
sub phr_parse {
    my ($phr) = @_;

    my @wrds; # массив слов и словосочетаний фразы
    while ($phr =~ m!(\[[^\]]+\]|<[^>]+>|\{[^\}]+\}|[^ ]+(?= |$))!g) { #[.Производители техники/Разработчики/] led-телевизор [samsung/loewe/philips/toshiba/hitachi/orion/grundig/lg] <плеер pioneer> dv {Супермаркеты электроники и бытовой техники} 610 av
        push @wrds, $1;
    }

    return @wrds;
}


#--- декартово произведение двух множеств ---
sub cart_prod {
    my ($a, $b, $DEL) = @_;
    $DEL = " " unless $DEL; #разделитель "слов"

    my @prod;
    unless (@$a) {
        @prod = @$b; 
    } else {
        for my $a (@$a) {
            push @prod, $a ? "$a$DEL$_" : $_ for @$b;
        }
    }

    return @prod;
}


#--- развертка именованного атома ---
sub atom_named_exp {
    my ($atom) = @_;

    my @phl = atom_raw_phrases($atom);
    if (@phl) {
        my @atom_phrs;
        for my $phr (@phl) {
            my @wrds_comb; # массив всевозможных комбинаций слов и словосочетаний фразы

            my @wrds = phr_parse($phr); #слова фразы
            for my $wrd (@wrds) {
                my @tmp;
                if ($wrd =~ /^\[/) { #атом
                    $wrd =~ s/^\[//;
                    $wrd =~ s/\]$//;
                    $wrd =~ s/^ +//;
                    $wrd =~ s/ +$//;
                    for (split m{/}, $wrd) {
                        push @tmp, $_;
                    }
                    push @tmp, "" if $wrd =~ m{/$};
                } else { #не атом
                    push @tmp, $wrd;
                }
                @wrds_comb = cart_prod(\@wrds_comb, \@tmp);
            }

            for (@wrds_comb) {
                s/^ +//;
                s/ +$//;
                s/  +/ /g;
            }
            push @atom_phrs, @wrds_comb;
        }
        return @atom_phrs;
    } else {
        return ($atom);
    }
}


#--- "сырые" фразы атома ---
sub atom_raw_phrases {
    my ($atom) = @_;

    my @phrases = ();                                                                                                                                                                                           
    my $category = $atom;                                                                                                                                                                  
    $category =~ s/^hier\./\./; #иерархический атом
    my @bfs_queue = ($category);                                                                                                                                                                                
    while (@bfs_queue) {                                                                                                                                                                                        
        my $root_category = shift(@bfs_queue);                                                                                                                                                                  
        push(@phrases, $proj->get_language('ru')->get_category_raw_phrases($root_category));                                                                                                                    
        push(@bfs_queue, $_) for $proj->categs_tree->get_minicateg_children($root_category);                                                                                                                    
    }
    return @phrases;
}
