#!/usr/bin/perl -w
#выбор атомов для развертки при поиске дублей в категориях

use strict;

use utf8;
use open ":utf8";
use Data::Dumper;

binmode STDIN, ':utf8';
binmode STDOUT, ':utf8';
binmode STDERR, ':utf8';


my %natoms; #именованные атомы
open F, "named_atoms";
while (<F>) {
    chomp;
    my ($atom, $size) = split /\t/;
    $natoms{"[$atom]"} = $size;
}

=z
for (sort keys %natoms) {
    print "$_\t$natoms{$_}\n";
}
exit;
=cut

my $task_size = 0;
my $rec_count = 0; #####
my $atom_count = 0;
while (my $rec = <STDIN>) { #/home/yuryz/scripts/phrs4ctgs/phrs_dupl/phrs_ctgs_dup.(dir|inv) (результаты phr_ctgs_expand1.pl)
    chomp $rec;
    $rec_count++; #####

    my ($phr, $ctg) = split /\t/, $rec; #фраза, категория
    my @wds = phr_parse($phr); #слова фразы
    my $rec_size = 1;
    for my $wd (@wds) {
        if ($wd =~ /^\[/ && $natoms{$wd}) {
            $rec_size *= $natoms{$wd};
            $atom_count++;
            #print "\t$rec_count\t\t$wd\t$rec_size\n";
        }
    }
    $task_size += $rec_size;
    print "$rec_count\t$task_size\n" if $rec_size > 1;
}
print "TASK_SIZE=$task_size\n";
print "REC_COUNT=$rec_count\n";
print "ATOM_COUNT=$atom_count\n";


#--- парсинг строки с фразами ---
sub phr_parse {
    my ($phr) = @_;

    my @wrds; # массив слов и словосочетаний фразы
    while ($phr =~ m!(\[[^\]]+\]|<[^>]+>|\{[^\}]+\}|[^ ]+(?= |$))!g) { #[.Производители техники/Разработчики/] led-телевизор [samsung/loewe/philips/toshiba/hitachi/orion/grundig/lg] <плеер pioneer> dv {Супермаркеты электроники и бытовой техники} 610 av
        push @wrds, $1;
    }

    return @wrds;
}
