#!/usr/bin/perl -w
#поиск мусорных подфраз на вхождение во фразы Каталогии

use strict;

use utf8;
use open ":utf8";
use Data::Dumper;

binmode STDIN, ':utf8';
binmode STDOUT, ':utf8';
binmode STDERR, ':utf8';

my %index; #индекс для поиска в файле rest_trash (хеш массивов)
open F, "trash_index";
while (<F>) {
    chomp;
    my ($word, $num) = split /\t/;
    push @{$index{$word}}, $num;
}

my $cnt = 0; #####
while (my $rec = <STDIN>) { #trash
    $cnt++; #####
    print STDERR "$cnt\n" if $cnt % 10000 == 0; #####

    chomp $rec;
    my ($phr, $id, $num) = split /\t/, $rec; #<фраза>, <ID категории>, <номер фразы в категории>
    
    my @wds = phr_parse($phr); #слова фразы
    my @find;
    for my $wds (@wds) {
        $wds = lc($wds);
        last unless $index{$wds}; #мусорная фраза не входит ни в какие другие фразы Каталогии
        push @find, \@{$index{$wds}};
    }
    next if !@find || @wds != @find; #индексы найдены не для всех слов мусорной фразы

    my @cross; #номера записей в файле rest_trash, содержащих ЦЕЛИКОМ данную мусорную подфразу
    for my $i (0..$#find) { #пересечение найденных индексов
        @cross = cross(\@cross, $find[$i]);
        last unless @cross;
    }
    if (@cross) {
        for my $num (@cross) {
            print "$num\t$rec\n";
        }
    }
}


#--- парсинг строки с фразами ---
sub phr_parse {
    my ($phr) = @_;

    my @wrds; # массив слов и словосочетаний фразы
    while ($phr =~ m!(\[[^\]]+\]|<[^>]+>|\{[^\}]+\}|[^ ]+(?= |$))!g) { #[.Производители техники/Разработчики/] led-телевизор [samsung/loewe/philips/toshiba/hitachi/orion/grundig/lg] <плеер pioneer> dv {Супермаркеты электроники и бытовой техники} 610 av
        push @wrds, $1;
    }

    return @wrds;
}


#--- пересечение строк 2-х индексов ---
sub cross {
    my ($a, $b) = @_;

    my @cross;
    unless (@$a) {
        @cross = @$b; 
    } else {
        my %cross;
        for my $a (@$a) {
            $cross{$a} = 1;
        }
        for my $b (@$b) {
            push @cross, $b if $cross{$b};
        }
    }

    return @cross;
}
