#!/usr/bin/perl -w
#выбор мусорных подфраз из файла rest и построение поискового индекса

use strict;

use utf8;
use open ":utf8";
use Data::Dumper;

binmode STDIN, ':utf8';
binmode STDOUT, ':utf8';
binmode STDERR, ':utf8';

my %trash; #словарь мусорных подфраз
open F, "trash_dict";
while (<F>) {
    chomp;
    $trash{$_} = 1;
}

open F, ">rest_trash";
my $find_count = 0;
while (<STDIN>) { #rest

    chomp;
    my ($phr, $id, $num) = split /\t/; #<фраза>, <ID категории>, <номер фразы в категории>
    
    my @wds = phr_parse($phr);
    my @find; #найденные подфразы 
    for my $wds (@wds) {
        $wds = lc($wds); ###
        if ($trash{$wds}) {
            push @find, $wds;
        }
    }

    if (@find) {
        print F "$_\n";

        $find_count++;
        print STDERR "$find_count\n"; # номера фраз, входящих в индекс 
        for my $find (@find) {
            print "$find\t$find_count\n"; #индекс
        }
    }
}


#--- парсинг строки с фразами ---
sub phr_parse {
    my ($phr) = @_;

    my @wrds; # массив слов и словосочетаний фразы
    while ($phr =~ m!(\[[^\]]+\]|<[^>]+>|\{[^\}]+\}|[^ ]+(?= |$))!g) { #[.Производители техники/Разработчики/] led-телевизор [samsung/loewe/philips/toshiba/hitachi/orion/grundig/lg] <плеер pioneer> dv {Супермаркеты электроники и бытовой техники} 610 av
        push @wrds, $1;
    }

    return @wrds;
}
