#!/usr/bin/perl -w
#выбор мусорных записей и составление словаря мусорных подфраз

use strict;

use utf8;
use open ":utf8";
use Data::Dumper;

binmode STDIN, ':utf8';
binmode STDOUT, ':utf8';
binmode STDERR, ':utf8';

my %trash; #словарь мусорных подфраз

my $cnt = 0; #####
open F, ">rest";
while (<STDIN>) { #phrs_ctgs_dup.dir
    $cnt++; #####
    print STDERR "$cnt\n" if $cnt % 10000 == 0; #####

    chomp;
    my ($phr, $id, $num) = split /\t/; #<фраза>, <ID категории>, <номер фразы в категории>
    if ($phr =~ /\d/ && $phr =~ /^[A-Za-z\d -]+$/) { #мусор
        print "$_\n";
        my @trash = phr_parse($phr);
        for my $trash (@trash) {
            next unless $trash =~ /[A-Za-z]/;
            $trash = lc($trash); ###
            $trash{$trash} = 1 unless $trash{$trash};
        }
    } else {
        print F "$_\n";
    }
}

open F, ">trash_dict";
for (sort keys %trash) {
    print F "$_\n";
}


#--- парсинг строки с фразами ---
sub phr_parse {
    my ($phr) = @_;

    my @wrds; # массив слов и словосочетаний фразы
    while ($phr =~ m!(\[[^\]]+\]|<[^>]+>|\{[^\}]+\}|[^ ]+(?= |$))!g) { #[.Производители техники/Разработчики/] led-телевизор [samsung/loewe/philips/toshiba/hitachi/orion/grundig/lg] <плеер pioneer> dv {Супермаркеты электроники и бытовой техники} 610 av
        push @wrds, $1;
    }

    return @wrds;
}
