#!/usr/bin/perl -w
#развертка атомов при поиске дублей в категориях

use strict;

use utf8;
use open ":utf8";
use Data::Dumper;

binmode STDIN, ':utf8';
binmode STDOUT, ':utf8';
binmode STDERR, ':utf8';

use lib "/home/yuryz/arcadia/rt-research/broadmatching/scripts/lib";
use Project;

my $proj = Project->new({ 
    load_dicts => 1,
    load_minicategs_light => 1,
});


my %natoms; #именованные атомы
open F, "named_atoms";
while (<F>) {
    chomp;
    my ($atom, $size) = split /\t/;
    $proj->clog($atom, 'green'); #####
    my $phr = $proj->phrase("[$atom]");
    my $phl = $phr->expand_to_phl; #развернутый список фраз
    $natoms{"[$atom]"} = $phl;
}

=z
for (sort keys %natoms) {
    next unless /^\[\.Города Юго-Восточная Азия\]$/;
    print "$_\n";
    for (@{$natoms{$_}}) {
        print "\t'$_'\n";
    }
}
exit;
=cut

my $rec_out = 0; #####

while (my $rec = <STDIN>) { #atoms_lst.(dir|inv)
    chomp $rec;

    my ($phr, $ctg, $num) = split /\t/, $rec; #<фраза>, <ID категории>, номер фразы в категории
    next unless $phr =~ /\[/; #нет атомов для развертки
    my @words = phr_parse($phr); #слова фразы с атомами

    atom_exp(\@words, $ctg, $num); #развертка атомов
}


#--- парсинг строки с фразами ---
sub phr_parse {
    my ($phr) = @_;

    my @wrds; # массив слов и словосочетаний фразы
    while ($phr =~ m!(\[[^\]]+\]|<[^>]+>|\{[^\}]+\}|[^ ]+(?= |$))!g) { #[.Производители техники/Разработчики/] led-телевизор [samsung/loewe/philips/toshiba/hitachi/orion/grundig/lg] <плеер pioneer> dv {Супермаркеты электроники и бытовой техники} 610 av
        push @wrds, $1;
    }

    return @wrds;
}


#--- декартово произведение двух множеств ---
sub cart_prod {
    my ($a, $b) = @_;

    my @prod;
    unless (@$a) {
        @prod = @$b; 
    } else {
        for my $a (@$a) {
            push @prod, $a ? "$a $_" : $_ for @$b;
        }
    }

    return @prod;
}


#--- развертка атомов ---
sub atom_exp {
    my ($words, $ctg, $num) = @_;

    my @wrds_comb; # массив всевозможных комбинаций слов и словосочетаний фразы
    for my $wrd (@$words) {
        my @tmp;
        if ($wrd =~ /^\[/) { #атом
            @tmp = @{$natoms{$wrd}};
        } else {
            @tmp = ( $wrd );
        }
        @wrds_comb = cart_prod(\@wrds_comb, \@tmp);
    }

    $rec_out++; #####
    my $size = @wrds_comb+0;
    $proj->clog("$rec_out\t$size", 'green'); #####

    for (@wrds_comb) {
        s/^ +//;
        s/ +$//;
        s/  +/ /g;
        print "$_\t$ctg\t$num\n";
    }
}
