#!/usr/bin/perl -w
#выбор атомов для развертки при поиске дублей в категориях

use strict;

use utf8;
use open ":utf8";
use Data::Dumper;

binmode STDIN, ':utf8';
binmode STDOUT, ':utf8';
binmode STDERR, ':utf8';

use lib "/home/yuryz/arcadia/rt-research/broadmatching/scripts/lib";
use Project;

my $proj = Project->new({ 
    load_dicts => 1,
    load_minicategs_light => 1,
});


my %natoms; #именованные атомы (хеш хешей)
open F, "named_atoms";
while (<F>) {
    chomp;
    my ($atom, $size) = split /\t/;
    $proj->clog($atom, 'green'); #####
    my $phr = $proj->phrase("[$atom]");
    my $phl = $phr->expand_to_phl; #развернутый список фраз
    for (@$phl) { #индексирование атомов
        s/^ +//;
        s/ +$//;
        s/  +/ /g;
        $natoms{$_}{"[$atom]"} = 1;
    }
}

my %sense_not_atom; #семантические классы без атомов
open F, "sense_not_atom";
while (<F>) {
    chomp;
    $sense_not_atom{$_} = 1;
}


#--- блок записей для анализа ---
my @recs; #записи
my @keys; #ключи (семантические классы)
my @words; #слова
my @ctgs; #категории
my @atoms_pos; #позиции первых атомов во фразах
my @nums; #номера фраз в категориях

my $rec_count = 0; #####
while (my $rec = <STDIN>) { #phrs_ctgs_dup.rest
    $rec_count++; #####
    #print STDERR "$rec_count\n" if $rec_count % 10000 == 0; #####

    chomp $rec;

    my ($sense, $len, $phr, $ctg, $num) = split /\t/, $rec; #"смысл", длина фразы, фраза, ID категории, номер фразы в категории
    my $key = "$sense\t$len";
    next if $sense_not_atom{$key};

    my @wds = phr_parse($phr); #слова фразы

    my $atoms_pos = -1;
    for my $i (0..$#wds) {
        if ($wds[$i] =~ /^\[/) { #атом
            $atoms_pos = $i;
            last;
        }
    }

    my $ret = add_to_class($rec, $key, \@wds, $ctg, $atoms_pos, $num); #добавить запись к семантическому классу
    prn_class($rec, $key, \@wds, $ctg, $atoms_pos, $num) unless $ret; #печать класса
}
prn_class("", "", "", "", 0, 0);


#--- парсинг строки с фразами ---
sub phr_parse {
    my ($phr) = @_;

    my @wrds; # массив слов и словосочетаний фразы
    while ($phr =~ m!(\[[^\]]+\]|<[^>]+>|\{[^\}]+\}|[^ ]+(?= |$))!g) { #[.Производители техники/Разработчики/] led-телевизор [samsung/loewe/philips/toshiba/hitachi/orion/grundig/lg] <плеер pioneer> dv {Супермаркеты электроники и бытовой техники} 610 av
        push @wrds, $1;
    }

    return @wrds;
}


#--- добавление записей к классу ---
sub add_to_class {
    my ($rec, $key, $wds, $ctg, $atoms_pos, $num) = @_; #$wds - ссылка на массив
    if (@recs == 0 || $keys[0] eq $key) {
        push @recs, $rec;
        push @keys, $key;
        push @words, $wds;
        push @ctgs, $ctg;
        push @atoms_pos, $atoms_pos;
        push @nums, $num;

        return 1;
    }
    return 0;
}


#--- печать класса ---
sub prn_class {
    my ($rec, $key, $wds, $ctg, $atoms_pos, $num) = @_; #$wds - ссылка на массив

    if (@recs > 1) {
        my $is_diff = 0; #наличие разных категорий в классе
        for my $i (1..$#recs) {
            if ($ctgs[$i] ne $ctgs[0]) {
                $is_diff = 1;
                last;
            }
        }

        if ($is_diff) {
my $sign = "$keys[0]\t".(@recs+0);
$proj->clog("BEG:$sign", 'green'); #####
            for my $i (0..$#recs) {
                next if $atoms_pos[$i] == -1;

                my $flag = 0;
                for (my $j = $i-1; $j >= 0; $j--) { #ВЕРХНЯЯ ОКРЕСТНОСТЬ
                    next if $ctgs[$i] eq $ctgs[$j];
                    my $min_pos = $atoms_pos[$i] <= $atoms_pos[$j] || $atoms_pos[$j] == -1 ? $atoms_pos[$i] : $atoms_pos[$j]; #min начальная позиция атома
                    my $keyI = $min_pos > 0 ? join(" ", @{$words[$i]}[0..$min_pos-1]) : "";
                    my $keyJ = $min_pos > 0 ? join(" ", @{$words[$j]}[0..$min_pos-1]) : "";
                    last if $keyI ne $keyJ;
=z
if ($keyI ne "") {
print "1. $min_pos\n";
print "'$keyI'\t$recs[$i]\n";
print "'$keyJ'\t$recs[$j]\n";
print "--\n";
}
=cut
                    if (conj($words[$i], $words[$j])) { #ссылки на массивы "слов"
                        print join(" ", @{$words[$i]}), "\t$ctgs[$i]\t$nums[$i]\n";
                        $flag = 1;
                        last;
                    }
                }

                if ($flag == 0) {
                    for my $j ($i+1..$#recs) { #НИЖНЯЯ ОКРЕСТНОСТЬ
                        next if $ctgs[$i] eq $ctgs[$j];
                        my $min_pos = $atoms_pos[$i] <= $atoms_pos[$j] || $atoms_pos[$j] == -1 ? $atoms_pos[$i] : $atoms_pos[$j]; #min начальная позиция атома
                        my $keyI = $min_pos > 0 ? join(" ", @{$words[$i]}[0..$min_pos-1]) : "";
                        my $keyJ = $min_pos > 0 ? join(" ", @{$words[$j]}[0..$min_pos-1]) : "";
                        last if $keyI ne $keyJ;
=z
if ($keyI ne "") {
print "2. $min_pos\n";
print "'$keyI'\t$recs[$i]\n";
print "'$keyJ'\t$recs[$j]\n";
print "--\n";
}
=cut
                        if (conj($words[$i], $words[$j])) { #ссылки на массивы "слов"
                            print join(" ", @{$words[$i]}), "\t$ctgs[$i]\t$nums[$i]\n";
                            last;
                        }
                    }
                }
            }
$proj->clog("END:$sign", 'green'); #####
        }
    }

    @recs = ($rec);
    @keys = ($key);
    @words = ($wds);
    @ctgs = ($ctg);
    @atoms_pos = ($atoms_pos);
    @nums = ($num);
}


#--- конъюнкция двух кортежей ---
sub conj {
    my ($a, $b) = @_; #ссылки на массивы "слов"
    return 0 if @$a * @$b == 0 || @$a != @$b;
    for my $i (0..$#{$a}) {
        next if $$a[$i] =~ /^\[/ || $$b[$i] =~ /^\[/ || $$a[$i] eq $$b[$i];
        return 0;
    }
    return 1;
}
