#!/usr/bin/perl -w
#фильтрация фраз - этап 1

use strict;

use utf8;
use open ":utf8";
use Data::Dumper;

binmode STDIN, ':utf8';
binmode STDOUT, ':utf8';
binmode STDERR, ':utf8';

use lib "/home/yuryz/arcadia/rt-research/broadmatching/scripts/lib";
use Project;

my $proj = Project->new({ 
    load_dicts => 1,
    load_minicategs_light => 1,
});


my %natoms; #именованные атомы (хеш хешей)
open F, "named_atoms";
while (<F>) {
    chomp;
    my ($atom, $size) = split /\t/;
    $proj->clog($atom, 'green'); #####
    my $phr = $proj->phrase("[$atom]");
    my $phl = $phr->expand_to_phl; #развернутый список фраз
    for (@$phl) { #индексирование атомов
        s/^ +//;
        s/ +$//;
        s/  +/ /g;
        $natoms{$_}{"[$atom]"} = 1; #для построения семантического класса
    }
}

my %sense_not_atom; #семантические классы без атомов (типа "[.Фамилии]") - для сокращения обработки

open F, ">phrs_ctgs_dup.rest.s";

my $prev_phr = "";
my @dupl;
my $rec_count = 0; #####
while (<STDIN>) { #phrs_ctgs_dup.dir
    $rec_count++; #####
    $proj->clog($rec_count, 'green') if $rec_count % 10000 == 0; #####

    chomp;
    my ($phr, $id, $num) = split /\t/; #фраза, ID категории, номер фразы в категории
    if ($prev_phr ne $phr) {
        if (@dupl > 1) {
            print "$_\n" for @dupl;
        }
        entry($dupl[0]) if @dupl > 0; #проверка вхождения в атомы и формирование семантического класса

        $prev_phr = $phr;
        @dupl = ( $_ );
    } else {
        push @dupl, $_;
    }
}
if (@dupl > 1) {
    print "$_\n" for @dupl;
}
entry($dupl[0]) if @dupl > 0;

open F, ">sense_not_atom";
for (sort keys %sense_not_atom) {
    print F "$_\n" if $sense_not_atom{$_} eq "NO";
}


#--- парсинг строки с фразами ---
sub phr_parse {
    my ($phr) = @_;

    my @wrds; # массив слов и словосочетаний фразы
    while ($phr =~ m!(\[[^\]]+\]|<[^>]+>|\{[^\}]+\}|[^ ]+(?= |$))!g) { #[.Производители техники/Разработчики/] led-телевизор [samsung/loewe/philips/toshiba/hitachi/orion/grundig/lg] <плеер pioneer> dv {Супермаркеты электроники и бытовой техники} 610 av
        push @wrds, $1;
    }

    return @wrds;
}


#--- декартово произведение двух множеств ---
sub cart_prod {
    my ($a, $b) = @_;

    my @prod;
    unless (@$a) {
        @prod = @$b; 
    } else {
        for my $a (@$a) {
            push @prod, $a ? "$a $_" : $_ for @$b;
        }
    }

    return @prod;
}


#--- проверка вхождения в атомы и формирование семантического класса ---
sub entry {
    my ($rec) = @_;

    my ($phr, $id, $num) = split /\t/, $rec; #фраза, ID категории, номер фразы в категории
    my @words = phr_parse($phr); #слова фразы
    my $len = sprintf "%02d", @words+0; #длина фразы

    my @atoms_comb; # набор семантических классов фразы
    my $is_atom = 0;
    for (@words) {
        my @atoms;
        if (/^\[/) { #атом
            push @atoms, $_;
            $is_atom = 1;
        } elsif ($natoms{$_}) { #слово входит в атомы
            for my $atom (keys %{$natoms{$_}}) {
                push @atoms, $atom;
            }
        }
        @atoms_comb = cart_prod(\@atoms_comb, \@atoms) if @atoms;
    }

    for my $atom_comb (@atoms_comb) {
        $atom_comb =~ s/^ +//;
        $atom_comb =~ s/ +$//;
        $atom_comb =~ s/  +/ /g;
        my @sense = phr_parse($atom_comb);
        my $sense = join("", sort @sense); #семантический класс фразы
        
        my $key = "$sense\t$len";
        unless ($sense_not_atom{$key} && $sense_not_atom{$key} eq "YES") {
            $sense_not_atom{$key} = $is_atom == 1 ? "YES" : "NO";
        }

        print F "$key\t$rec\n";
    }
}
