#!/usr/bin/perl -w
#выбор фраз из Каталогии для поиска дублей (чтобы иметь фиксированную базу на момент обработки)

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';
use Data::Dumper;

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

use lib "/home/yuryz/arcadia/rt-research/broadmatching/scripts/lib";
use Project;

my $proj = Project->new({ 
    load_dicts => 1,
    load_minicategs_light => 1,
});


`curl https://catmedia.yandex.ru/acgi-bin/interface/get_categs_tree.pl >ctgs_full_list`; #выдает все категории
open F, "ctgs_full_list";
while (<F>) {
    chomp;

    my ($sign, $id, $id_parent, $ctg) = split /\t/; #обозначение, ID категории, ID родителя, название

    my $ctg_phrs = $proj->phrase($ctg)->get_category_phrases; #список фраз категорий
    if (@$ctg_phrs) {
        my $phr_num = 0; #порядковый номер фразы внутри категории
        for my $ctg_phr (@$ctg_phrs) {
            $phr_num++;
            print "$ctg_phr\t$id\t$phr_num\n";
        }
    }
}
