#!/usr/bin/python
# -*- coding: utf-8 -*-

#печать баннеров для проверки

import sys
import yt.wrapper as yt

BNRS_MAX = 1 #максимальное число баннеров, выбираемых из каждой категории
RANK_MAX = 1 #максимальный ранг, начиная с которого выбираются баннеры


def bnr_sel(key, recs): #выбор и печать баннера
    bnr_cnt = 0
    for rec in recs:
        bnr_cnt += 1
        if bnr_cnt <= BNRS_MAX:
            if -rec['rank_rel'] <= RANK_MAX:
                yield rec


def main():
    input = '//home/catalogia/users/yuryz/bnrs_etalon_s'
    output = '//home/catalogia/users/yuryz/bnrs4check'

    yt.run_sort('//home/catalogia/users/yuryz/bnrs_etalon', '//home/catalogia/users/yuryz/bnrs_etalon_s', sort_by=['mctgs', 'rank_rel', 'bid'])

    yt.run_reduce(bnr_sel, input, output, reduce_by=['mctgs'])
    yt.run_sort(output, sort_by=['rank_rel', 'bid'])

    print >>sys.stderr, yt.row_count(input)
    print >>sys.stderr, yt.row_count(output)

    yt.remove(input)

    for rec in yt.read_table(output, raw=False):
        print rec['mctgs'] + '\t' + str(rec['bid']) + '\t' + rec['title'] + '\t' + rec['body']+ '\t' + str(-rec['rank_rel'])


if __name__ == '__main__':
    main()
