#!/usr/bin/python
# -*- coding: utf-8 -*-

#полная кластеризация баннеров с помощью q-граммной метрики

import re
import yt.wrapper as yt

SIM_MIN = 0.70 #min степень сходства элементов кластера
Q = 2 #длина q-граммы

def qgr_dst(a, b):
    D = {}
    dst = 0

    a = unicode(a, 'utf-8')
    b = unicode(b, 'utf-8')

    k = Q - len(a)
    a += ' ' * k #дополнение коротких строк пробелами
    for i in range(len(a)-Q+1):
        if D.has_key(a[i:i+Q]):
            D[a[i:i+Q]] += 1
        else:
            D[a[i:i+Q]] = 1
        dst += 1

    k = Q - len(b)
    b += ' ' * k
    for i in range(len(b)-Q+1):
        if D.has_key(b[i:i+Q]):
            D[b[i:i+Q]] -= 1
            if D[b[i:i+Q]] >= 0:
                dst -= 1
            else:
                dst += 1
        else:
            D[b[i:i+Q]] = -1
            dst += 1

    dst /= float(min(len(a), len(b)))
    dst = float('%.3f' % (1 - dst))
    return dst


SHINGLE_LEN = 3

def shingle(rec):
    L = rec['clast'].split()
    if len(L) < SHINGLE_LEN:
        rec['shingle'] = ' '.join(L)
        yield rec
    else:
        for i in range(len(L) - SHINGLE_LEN + 1):
            shingle = ' '.join(L[i:i+SHINGLE_LEN])
            rec['shingle'] = shingle
            yield rec


def compr(key, recs): #сжатие дублей
    rec = next(recs)
    yield rec


def clast(key, recs):
    CL = []
    for rec in recs:
        flag = 0
        sim_max = 0
        for i in range(len(CL)):
            sim = float(qgr_dst(rec['clast'], CL[i]['clast']))
            if sim >= SIM_MIN:
                flag = 1
                if sim > sim_max:
                    sim_max = sim
                    i_max = i

        if flag == 0:
            CL.append(rec)
        else:
            rec['clast_sup'] = CL[i_max]['clast'] #включающий кластер
            rec['sim'] = -sim_max
            yield rec

    #for rec in CL:
    #    yield rec


def main():
    tab2 = '//tmp/yuryz/clast1_exp'
    siz_in = yt.row_count(tab2)
    tab2a = '//tmp/yuryz/clast1a_exp'

    print "ВЫЧИСЛЕНИЕ ШИНГЛОВ = " + str(SHINGLE_LEN)
    yt.run_map(shingle, tab2, tab2a)
    yt.run_sort(tab2a, sort_by=['mctgs', 'shingle', 'clast', 'bid'])
    siz_mid = yt.row_count(tab2a)

    print "УДАЛЕНИЕ ДУБЛЕЙ"
    tab2b = '//tmp/yuryz/compr'
    yt.run_reduce(compr, tab2a, tab2b, reduce_by = ['mctgs', 'shingle', 'clast', 'bid']) #сжатие дублей
    yt.run_sort(tab2b, sort_by=['mctgs', 'shingle', 'clast', 'bid'])

    tab3 = '//tmp/yuryz/clast2_exp'

    print "КЛАСТЕРИЗАЦИЯ"
    yt.run_reduce(clast, tab2b, tab3, reduce_by = ['mctgs', 'shingle'])

    print "СОРТИРОВКА"
    #yt.run_sort(tab3, sort_by=['mctgs', 'shingle', 'clast', 'bid'])
    yt.run_sort(tab3, sort_by=['mctgs', 'clast_sup', 'sim', 'bid'])

    #yt.move(tab2, '//tmp/yuryz/tab_tmp')
    #yt.move(tab3, tab2)
    #yt.move('//tmp/yuryz/tab_tmp', tab3)

    yt.remove(tab2a)
    yt.remove(tab2b)

    siz_out = yt.row_count(tab2)

    #print siz_in
    #print siz_mid
    #print siz_out


if __name__ == '__main__':
    main()
