#!/usr/bin/perl -w
#категоризация баннеров эталонной выборки

use strict;

use utf8;
use open ":utf8";
use Data::Dumper;

binmode STDIN, ':utf8';
binmode STDOUT, ':utf8';
binmode STDOUT, ':utf8';

use FindBin;
use lib "$FindBin::Bin/../lib";
use lib "/home/yuryz/arcadia/rt-research/broadmatching/scripts/lib";

use Utils::Common;
use Project;

my $proj = Project->new({
    load_dicts   => 1,
    load_minicategs_light => 1, 
});

my $worker = Utils::Worker->new;
$worker->{verbose}    = 1;
$worker->{num_processes}    = 20;

$worker->{file_input}       = "/home/yuryz/scripts/sample/bnr_hash_u";
$worker->{file_output}      = "/home/yuryz/scripts/sample/bnrs_ctg";

$worker->{process_line}     = sub {
    my ($line, $fh) = @_;
    chomp $line;

    my ($bid) = split /\t/, $line;

    my $bnr = $proj->bf->get_banner_by_id($bid);
    return unless $bnr;

    my @ctgs = $bnr->get_minicategs;
    return if @ctgs == 0;
    return if @ctgs > 1; #####

    my $title = $bnr->title;
    my $body = $bnr->body;
    print $fh "$bid\t$title\t$body\t$ctgs[0]\n";
};

$worker->process_data;
