#!/usr/bin/python
# -*- coding: utf-8 -*-

#выбор баннеров для проверки качества категоризации

import random
import yt.wrapper as yt


def bnrs_select(key, recs): #случайный выбор баннера
    num = 0
    for rec in recs:
        num += 1
        if random.uniform(0, num) < 1:
            row = rec
    yield rec


def main():
    #tab1 = '//home/catalogia/users/yuryz/bnrs_norm'
    tab1 = '//home/catalogia/users/yuryz/bnrs_rank_rel_s'
    tab2 = '//tmp/yuryz/bnrs_norm_s'

    yt.run_sort(tab1, tab2, sort_by=['mctgs', 'bid'])

    tab3 = '//tmp/yuryz/bnrs4test'

    yt.run_reduce(bnrs_select, tab1, tab3, reduce_by=['mctgs'])

    #yt.run_reduce(bnrs_select, tab2, tab3, reduce_by=['mctgs'])
    #yt.run_sort(tab3, sort_by=['bid'])

    #print yt.row_count(tab1)
    #print yt.row_count(tab2)


if __name__ == '__main__':
    main()
