#!/usr/bin/python
# -*- coding: utf-8 -*-

# "" 

import yt.wrapper as yt


def reducer(key, recs):
    mctgs = ''
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0:
            mctgs = rec['mctgs']
        else:
            if mctgs != '':
                yield { "mctgs": rec['mctgs'], "bid": rec['bid'], "title": rec['title'], "body": rec['body'], "rank_rel": rec['rank_rel'] }


def main():
    input_1 = '//home/catalogia/users/yuryz/ctgs_good_100'
    input_2 = '//home/catalogia/users/yuryz/bnrs_rank_rel_s'
    output = '//home/catalogia/users/yuryz/bnrs_etalon'

    yt.run_reduce(reducer, [input_1, input_2], output, reduce_by = ['mctgs'])
    yt.run_sort(output, sort_by=['rank_rel', 'bid'])

    print yt.row_count(input_1)
    print yt.row_count(input_2)
    print yt.row_count(output)


if __name__ == '__main__':
    main()
