#!/usr/bin/perl -w
#декартово произведение 2-х множеств (списков)

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';
use Data::Dumper;

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");


my @a;
while (<DATA>) {
    chomp;
    my ($word, @rank) = split / /;
    push @a, \@rank;
}
#print @a+0, "\n";

my @prod;
my @b = (2, 3, 4);
for my $i (@b) {
    @prod = cart_prod(\@prod, $a[$i], @b+0);
    unless (@prod) {
        @prod = ();
        last;
    }
}
print "$_\n" for @prod;


#--- декартово произведение двух множеств ---
sub cart_prod {
    my ($a, $b, $core_size) = @_; #$core_size - размер семантического ядра (число слов в нем)

    $a = [""] unless @$a;
    my @prod;
    for my $a (@$a) {
        for my $b (@$b) {
            last if $b > $core_size;
            push @prod, $a ? "$a $b" : $b if $a !~ /("$b "|" $b"|$b)/; #номер $b не должен содержаться в списке номеров $a
        }
    }

    return @prod;
}

__DATA__
0-0 3 4 5 6 7 9
0-0-10 1 2
0-0-12 2 3 4
0-0-24 2 3 4 5 6 7 8
0-0-3 2 3
0-0-36 2 3 4 5
0-0-4 4
0-01-ц 2 3
0-02-ц 2 3 5
0-03-804 3
0-1 2 3 4 5 6 7 8 9 10
