#!/usr/bin/perl -w
#выбор категории по семантическому ядру

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';
use Data::Dumper;

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

use lib "/home/yuryz/arcadia/rt-research/broadmatching/scripts/lib";
use Project;

my $proj = Project->new({ 
    load_dicts => 1,
    load_minicategs_light => 1,
});


my %ctg;
open F, "ctg_list";
while (<F>) {
    chomp;
    my ($ctg, $ctg_id) = split /\t/;
    $ctg{$ctg_id} = $ctg
}

my %filter;
open F, "wrd_ctg_tf_idf"; #словарь весов tf_idf (в контексте категорий) всех слов в ядрах Каталогии
while (<F>) {
    chomp;
    my ($word, $tf_idf) = split /\t/;
    $filter{$word} = $tf_idf;
}

my %index;
open F, "two_word_index";
my $cnt = 0;
my $size = (stat(F))[7];
while (<F>) {
    progress(tell(F), $size, 'Загрузка словаря two_word_index') if ++$cnt % 5000 == 0;
    chomp;
    my ($pair, $ind1, $ind2) = split /\t/;
    $index{$pair} = "$ind1\t$ind2";
}
print STDERR "\n";


my @core;
open F, "core_index_id";
$cnt = 0;
$size = (stat(F))[7];
while (<F>) {
    progress(tell(F), $size, 'Загрузка словаря core_index_id') if ++$cnt % 10000 == 0;
    chomp;
    push @core, $_;
}
print STDERR "\n";


while (<STDIN>) { #test
    chomp;

    my ($bid, $title, $body, $mctgs) = split /\t/;
    print "$bid\t$title\t$body\t$mctgs\n";

    my $bnr_pre = $proj->phrase("$title $body")->get_banner_prefiltered_phrase->text; #префильтрация баннера
    #print "$bnr_pre\n";
    my $bnr_nrm = $proj->phrase($bnr_pre)->norm_phr; #нормализация текста баннера
    #print "$bnr_nrm\n";

    my %dup;
    my @uniq = grep { !$dup{$_}++ } split / /, $bnr_nrm; #удаление дублей из нормализованного текста
    #print "[ @uniq ]\n";

    my @good;
    my %good;
    for my $uniq (@uniq) {
        if ($filter{$uniq}) { #фильтрация слов, не входящих НИ В КАКИЕ семантические ядра
            push @good, $uniq;
            $good{$uniq} = 1;
        }
    }
    print "[ @good ]\n";

    my @pair;
    for my $i (0..$#good-1) { #генерация пар слов для поиска семантического ядра
        for my $j ($i+1..$#good) {
            push @pair, "$good[$i] $good[$j]", "$good[$j] $good[$i]";
        }
        push @pair, $good[$i]; #учет ОДНОСЛОВНЫХ ядер
    }
    push @pair, $good[$#good];

    my $len_core_max = 0;
    my @sem_core_max;
    my @ctg_max;
    my @weight_max;
    my @size_max;
    for my $pair (@pair) {
        if ($index{$pair}) {
            my @ind = split /\t/, $index{$pair};
            my @sem_core;

            for my $i ($ind[0]..$ind[1]) {
                my ($core, $ctg, $weight, $size) = split /\t/, $core[$i];
                my @word = split / /, $core;
                my $flag = 0;
                for my $j (2..$#word) { # 2 - т.к. слова ядра 0 и 1 - уже совпадают с $pair
                    unless ($good{$word[$j]}) { #"чужое" слово - ядро не подходит
                        $flag = 1;
                        last;
                    }
                }
                push @sem_core, $core[$i] if $flag == 0;
            }

            #print "$pair\t$index{$pair}\n";
            for my $sem_core (@sem_core) {
                #print "\t$sem_core\n";
                my ($core, $ctg, $weight, $size) = split /\t/, $sem_core;
                push @sem_core_max, $core;
                push @ctg_max, $ctg;
                push @weight_max, $weight;
                push @size_max, $size;
            }
        }
    }

    if (@sem_core_max) { #массив ВСЕХ ядер (с ЛЮБЫМИ длинами!)
        my %weight_core;
        for my $i (0..$#sem_core_max) { #для каждого из найденных семантических ядер определяем его суммарный tf_idf
            my $weight_core = 0;
            my @word = split / /, $sem_core_max[$i];
            for my $word (@word) {
                $weight_core += $filter{$word} if $filter{$word};
            }
            #$weight_core /= @word; #среднее IDF
            $weight_core{"$sem_core_max[$i]\t$ctg_max[$i]\t$size_max[$i]\t$weight_max[$i]"} = $weight_core;
        }

        for my $core_ctg ( sort { $weight_core{$b} <=> $weight_core{$a} } keys %weight_core ) { #по убыванию весов
            my ($core, $ctg, $size, $weight) = split /\t/, $core_ctg;
            $ctg = $ctg{$ctg} if $ctg{$ctg};
            print "$core => $ctg => $size => $weight => $weight_core{$core_ctg}\n";
        }
        print "\n";
    }
}
print STDERR "OK\n";


#--- ProgressBar ---
sub progress {
    my ($count, $total, $status) = @_;
    my $bar_len = 50;
    my $filled_len = int(sprintf("%.f", $bar_len * $count / $total));

    my $percents = sprintf "%.1f", 100.0 * $count / $total;
    my $bar = ('■' x $filled_len).('-' x ($bar_len - $filled_len));

    printf STDERR "[%s] %s%s %s\r", $bar, $percents, '%', $status;
    STDERR->flush();
}
