#!/usr/bin/perl -w
#выбор категории по семантическому ядру

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';
use Data::Dumper;

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

use lib "/home/yuryz/arcadia/rt-research/broadmatching/scripts/lib";
use Project;

my $proj = Project->new({ 
    load_dicts => 1,
    load_minicategs_light => 1,
});


my %ctg;
open F, "ctg_list";
while (<F>) {
    chomp;
    my ($ctg, $ctg_id) = split /\t/;
    $ctg{$ctg_id} = $ctg
}

my %filter;
open F, "wrd_ctg_tf_idf"; #словарь весов tf_idf (в контексте категорий) всех слов в ядрах Каталогии
while (<F>) {
    chomp;
    my ($word, $tf_idf) = split /\t/;
    $filter{$word} = $tf_idf;
}

my %index;
open F, "two_word_index";
my $cnt = 0;
my $size = (stat(F))[7];
while (<F>) {
    progress(tell(F), $size, 'Загрузка словаря two_word_index') if ++$cnt % 5000 == 0;
    chomp;
    my ($pair, $ind1, $ind2) = split /\t/;
    $index{$pair} = "$ind1\t$ind2";
}
print STDERR "\n";


my @core;
open F, "core_index_id";
$cnt = 0;
$size = (stat(F))[7];
while (<F>) {
    progress(tell(F), $size, 'Загрузка словаря core_index_id') if ++$cnt % 10000 == 0;
    chomp;
    push @core, $_;
}
print STDERR "\n";


while (<STDIN>) { #test
    chomp;

    my ($bid, $title, $body, $mctgs) = split /\t/;
    print "$bid\t$title\t$body\t$mctgs\n";

    my $bnr_pre = $proj->phrase("$title $body")->get_banner_prefiltered_phrase->text; #префильтрация баннера
    #print "$bnr_pre\n";
    my $bnr_nrm = $proj->phrase($bnr_pre)->norm_phr; #нормализация текста баннера
    #print "$bnr_nrm\n";

    my %dup;
    my @uniq = grep { !$dup{$_}++ } split / /, $bnr_nrm; #удаление дублей из нормализованного текста
    #print "[ @uniq ]\n";

    my @good;
    my %good;
    for my $uniq (@uniq) {
        if ($filter{$uniq}) { #фильтрация слов, не входящих НИ В КАКИЕ семантические ядра
            push @good, $uniq;
            $good{$uniq} = 1;
        }
    }
    print "[ @good ]\n";

    my @pair;
    for my $i (0..$#good-1) { #генерация пар слов для поиска семантического ядра
        for my $j ($i+1..$#good) {
            push @pair, "$good[$i] $good[$j]", "$good[$j] $good[$i]";
        }
        push @pair, $good[$i]; #учет ОДНОСЛОВНЫХ ядер
    }
    push @pair, $good[$#good];

    my @sem_core;
    for my $pair (@pair) { #поиск семантических ядер
        if ($index{$pair}) {
            my @ind = split /\t/, $index{$pair};
            for my $i ($ind[0]..$ind[1]) { #средняя длина цепочки перебора примерно 11-12 ядер
                my ($core, $ctg, $weight, $size) = split /\t/, $core[$i];
                my @word = split / /, $core;
                my $flag = 0;
                for my $j (2..$#word) { # 2 - т.к. слова ядра 0 и 1 - уже совпадают с $pair
                    unless ($good{$word[$j]}) { #"чужое" слово - ядро не подходит
                        $flag = 1;
                        last;
                    }
                }

                if ($flag == 0) {
                    my $core_idf = 0;
                    my @word = split / /, $core;
                    for my $word (@word) {
                        $core_idf += $filter{$word} if $filter{$word}; #суммарный IDF всех слов ядра
                    }
                    #$core_idf /= @word; #среднее IDF
                    push @sem_core, "$core[$i]\t$core_idf";
                }
            }
        }
    }

    for my $i (0..$#sem_core) { #массив ВСЕХ гпйденных ядер, категории которых необходимо ранжировать
        my ($core, $ctg, $weight, $size, $core_idf) = split /\t/, $sem_core[$i];
        $ctg = $ctg{$ctg} if $ctg{$ctg};
        print "$core => $ctg => $size => $weight => $core_idf\n";
    }
    print "\n";
}
print STDERR "OK\n";


#--- ProgressBar ---
sub progress {
    my ($count, $total, $status) = @_;
    my $bar_len = 50;
    my $filled_len = int(sprintf("%.f", $bar_len * $count / $total));

    my $percents = sprintf "%.1f", 100.0 * $count / $total;
    my $bar = ('■' x $filled_len).('-' x ($bar_len - $filled_len));

    printf STDERR "[%s] %s%s %s\r", $bar, $percents, '%', $status;
    STDERR->flush();
}
