#!/usr/bin/python
# -*- coding: utf-8 -*-

#поиск омонимичных (входящих в несколько категорий) семантических ядер

import yt.wrapper as yt


def clast_size1(key, recs):
    mctgs_prev = ''
    flag = 0
    for rec in recs:
        if mctgs_prev == '':
            mctgs_prev = rec['mctgs']
            clast_size = 1
        elif mctgs_prev == rec['mctgs']:
            clast_size += 1
        else:
            flag = 1
            yield { "clast_phrase": key['clast_phrase'], "mctgs": mctgs_prev, "clast_size": -clast_size} #ЭТОТ ОПЕРАТОР ЗАКОММЕНТИРОВАТЬ при выводе ОДНОЗНАЧНЫХ категорий
            mctgs_prev = rec['mctgs']
            clast_size = 1
    if flag == 1: # 0 - однозначные категории для clast_phrase, 1 - омонимичные (clast_phrase входит в несколько категорий)
        yield { "clast_phrase": key['clast_phrase'], "mctgs": mctgs_prev, "clast_size": -clast_size }


def del_dup(key, recs): #сохранение только ПЕРВЫХ (самых частотных) ядер из нескольких вариантов
    yield recs.next()


def main():
    tab0 = '//home/catalogia/users/yuryz/tmp/bnrs_norm_sense' #см. tf_idf_4.py
    tab1 = '//tmp/yuryz/bnrs_norm_sense'

    yt.run_sort(tab0, tab1, sort_by=['clast_phrase', 'mctgs', 'bid'])

    tab2 = '//home/catalogia/users/yuryz/tmp/core_poli' #ядра, входящие в несколько категорий

    yt.run_reduce(clast_size1, tab1, tab2, reduce_by = 'clast_phrase')
    yt.run_sort(tab2, sort_by=['clast_phrase', 'clast_size', 'mctgs'])

    tab3 = '//home/catalogia/users/yuryz/tmp/core_one' #самые частотные ядра из входящих в несколько категорий

    yt.run_reduce(del_dup, tab2, tab3, reduce_by = ['clast_phrase'])
    yt.run_sort(tab3, sort_by=['clast_phrase'])

    print yt.row_count(tab1)
    print yt.row_count(tab2)


if __name__ == '__main__':
    main()
