#!/usr/bin/perl -w
#сжатие лингвистического индекса

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';
use Data::Dumper;

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

my %dict;
open F, "ctg_list";
while (<F>) {
    chomp;
    my ($ctg, $ctg_id) = split /\t/;
    $dict{$ctg} = $ctg_id
}

my $core_prev_1 = "";
my $ctg_prev_1 = "";
my $core_prev_2 = "";
my $ctg_prev_2 = "";
while (<STDIN>) { #core_index (см. read_table.py)
    chomp;
    my ($core, $ctg) = split /\t/;

    if ($ctg_prev_1 eq "") {
        $core_prev_1 = $core;
        $ctg_prev_1 = $ctg;
    } elsif($ctg_prev_1 eq $ctg) {
        $core_prev_2 = $core;
        $ctg_prev_2 = $ctg;
    } else {
        $ctg_prev_1 = $dict{$ctg_prev_1} if $dict{$ctg_prev_1};
        print "$core_prev_1\t$ctg_prev_1\n";
        if ($ctg_prev_2 ne "") {
            $ctg_prev_2 = $dict{$ctg_prev_2} if $dict{$ctg_prev_2};
            print "$core_prev_2\t$ctg_prev_2\n";
        }

        $core_prev_1 = $core;
        $ctg_prev_1 = $ctg;
        $core_prev_2 = "";
        $ctg_prev_2 = "";
    }
}
$ctg_prev_1 = $dict{$ctg_prev_1} if $dict{$ctg_prev_1};
print "$core_prev_1\t$ctg_prev_1\n";
if ($ctg_prev_2 ne "") {
    $ctg_prev_2 = $dict{$ctg_prev_2} if $dict{$ctg_prev_2};
    print "$core_prev_2\t$ctg_prev_2\n";
}
