#!/usr/bin/env bash
# формирование семантического ядра баннеров

# --- Построение таблицы семантических ядер баннеров Каталогии //home/catalogia/users/yuryz/tmp/bnrs_norm_sense ---
python tf_idf_1.py
python tf_idf_2.py
python tf_idf_3.py
python tf_idf_4.py #здесь указывается порог для формирования семантического ядра (сейчас - 0.96, при очень большом пороге может возникнуть переобучение

# --- Построение семантического словаря Каталогии <core_index_id, two_word_index> ---
python clast_size_distr_poli.py #выделение самых частотных из ядер, которые (ядра) входят в НЕСКОЛЬКО категорий
python read_core_index.py >core_index_id
two_word_index.pl <core_index_id >two_word_index

# --- Построение словаря слов Каталогии, входящих в ее семантический словарь core_index ---
perl -ne '{@a=split/\t/;@b=split/ /,$a[0];print "$_\n"for @b}' core_index_id |LC_ALL=C sort -u >word_filter
cat word_filter |sed 's/"/\\"/g' |awk -F'\t' '{print "{ \"word\": \""$1"\" }"}' |yt write //home/catalogia/users/yuryz/tmp/word_filter --format='<encode_utf8=false>json'
yt sort --src //home/catalogia/users/yuryz/tmp/word_filter --dst //home/catalogia/users/yuryz/tmp/word_filter --sort-by "word"

# --- Построение словаря семантических весов слов из ядер Каталогии (в контексте категорий) ---
python wrd_ctg_tf_idf_compr.py
python wrd_ctg_tf_idf_read.py >wrd_ctg_tf_idf
