#!/usr/bin/python
# -*- coding: utf-8 -*-

#формирование профиля категорий из ctg_top1000 (самых частотных) - выбор частотной лексики

import yt.wrapper as yt


def word_sel(key, recs): #выбор слов и их TF_IDF для категорий из ctg_top1000
    freq = 0
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0:
            freq = rec['freq']
        else:
            if freq != 0:
                yield { "mctgs": key['mctgs'], "word": rec['word'], "tf_idf": -rec['tf_idf'] }


TOP = 100 #количество слов, определяющих семантический профиль категории

def word_top(key, recs): #выбор слов с максимальными значениями TF_IDF для категорий из ctg_top1000
    count = 0
    for rec in recs:
        count += 1
        if count <= TOP:
            yield rec


def main():
    #yt sort --src //home/catalogia/users/yuryz/tmp/wrd_ctg_tf_idf --dst //tmp/yuryz/wrd_ctg_tf_idf --sort-by "mctgs" --sort-by "word"

    tab1 = '//home/catalogia/users/yuryz/tmp/ctg_top1000'
    tab2 = '//tmp/yuryz/wrd_ctg_tf_idf'

    tab3 = '//tmp/yuryz/wrd_ctg_top1000_tf_idf'

    yt.run_reduce(word_sel, [tab1, tab2], tab3, reduce_by = ['mctgs'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    yt.run_sort(tab3, sort_by=['mctgs', 'tf_idf', 'word'])

    tab4 = '//home/catalogia/users/yuryz/tmp/wrd_max_tf_idf'

    yt.run_reduce(word_top, tab3, tab4, reduce_by = 'mctgs')
    yt.run_sort(tab4, sort_by=['mctgs', 'tf_idf', 'word'])

    print yt.row_count(tab1)
    print yt.row_count(tab2)
    print yt.row_count(tab3)
    print yt.row_count(tab4)


if __name__ == '__main__':
    main()
