#!/usr/bin/python
# -*- coding: utf-8 -*-

#первичная подготовка данных из одной категории для кластеризации

import sys
import re
import yt.wrapper as yt

class ctg_sel(object):
    def __init__(self, ctg_name):
        self.ctg_name = ctg_name

    def __call__(self, rec):
        if rec['mctgs'] == self.ctg_name:
            L = rec['bnorm'].split()
            wrds = set(L) #удаляем дубли
            L = []
            for wrd in wrds:
                wrd = re.sub('^[!+$]+', '', wrd)
                if len(wrd) == 0 or re.findall('^([0-9]+|для|со|с)$', wrd) or re.findall('^_', wrd):
                    continue
                L.append(wrd)
            L.sort()

            if len(L) > 0:
                clast = " ".join(L)
                banner = rec['title'] + '\t' + rec['body']
                yield { "mctgs": rec['mctgs'], "clast": clast, "bid": rec['bid'], "banner": banner }


def main():
    tab1 = '//home/catalogia/users/yuryz/bnrs_norm'
    tab2 = '//tmp/yuryz/ctg4clast'

    print >> sys.stderr, sys.argv[1]

    yt.run_map(ctg_sel(sys.argv[1]), tab1, tab2)
    yt.run_sort(tab2, sort_by=['mctgs', 'clast', 'bid'])

    print >> sys.stderr, yt.row_count(tab1)
    print >> sys.stderr, yt.row_count(tab2)


if __name__ == '__main__':
    main()
