#!/usr/bin/python
# -*- coding: utf-8 -*-

#построение поискового индекса слов для категорий

import yt.wrapper as yt


def del_dup(key, recs): #удаление дублей
    rec = recs.next()
    yield { "word": rec['word'], "mctgs": rec['mctgs'], "tf_idf": rec['tf_idf'] }


def del_word_no_sense(key, recs): #удаление слов, не содержащихся в семантических ядрах
    flag = 0
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0:
            flag = 1 #есть совпадение с "плохим" словом
        else:
            if flag == 0:
                yield rec


def make_index(key, recs): #построение собственно индекса
    mctgs_list = ''
    for rec in recs:
        if mctgs_list != '':
            mctgs_list += '\t'
        mctgs_list += rec['mctgs'] + '\t' + str(rec['tf_idf'])
    yield { "word": key['word'], "mctgs_list": mctgs_list }


def main():
    tab1 = '//home/catalogia/users/yuryz/tmp/wrd2ctg_weight'
    tab2 = '//tmp/yuryz/wrd2ctg_weight'

    yt.run_sort(tab1, tab2, sort_by=['word', 'mctgs'])

    tab3 = '//tmp/yuryz/wrd2ctg_no_dup'

    yt.run_reduce(del_dup, tab2, tab3, reduce_by = ['word', 'mctgs'])
    yt.run_sort(tab3, sort_by=['word', 'mctgs'])

    tab4 = '//home/catalogia/users/yuryz/tmp/word_no_sense'
    tab5 = '//tmp/yuryz/wrd2ctg_no_bad'

    yt.run_reduce(del_word_no_sense, [tab4, tab3], tab5, reduce_by = ['word'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    yt.run_sort(tab5, sort_by=['word', 'mctgs'])

    tab6 = '//home/catalogia/users/yuryz/tmp/word_index'

    yt.run_reduce(make_index, tab5, tab6, reduce_by = ['word'])
    yt.run_sort(tab6, sort_by=['word'])

    print yt.row_count(tab1)
    print yt.row_count(tab2)

    print yt.row_count(tab3)

    print yt.row_count(tab4)
    print yt.row_count(tab5)

    print yt.row_count(tab6)


if __name__ == '__main__':
    main()
