#!/usr/bin/perl -w
#создание словаря слов, входящих в семантические ядра и получение списка их позиций в этих ядрах

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';
use Data::Dumper;

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

sub nextPermutation($)
{
    my $p=shift;
    my $i=$#$p-1;
    $i-- while $i>=0 and $p->[$i]>$p->[$i+1];
    if($i>=0)
    {
        my $j=$i+1;
        $j++ while $j<$#$p and $p->[$j+1]>$p->[$i];
        @$p[$i, $j]=@$p[$j, $i];
        push @$p, reverse splice @$p, $i+1;
        return $p;
    }
    return;
}

my $n=shift;
die "$0: Нужно неотрицательное число!\n" unless defined($n) and $n>=0;

for(my $p=[1..$n]; defined $p; $p=nextPermutation($p))
{
    print "@$p\n";
}
