#!/usr/bin/python
# -*- coding: utf-8 -*-

#формирование семантического словаря Каталогии

import sys
import re
import math

import yt.wrapper as yt


def sem_core(key, recs):
    yield { "mctgs": key['mctgs'], "clast_phrase": key['clast_phrase'], "clast_weight": float('%.3f' % -recs.next()['clast_weight']) }


def uniq(key, recs): #каждое ядро входит ровно в ОДНУ категорию
    mctgs = ''
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0:
            mctgs = rec['mctgs']
        else:
            if mctgs == '' or mctgs == rec['mctgs']: #уникальныке ядра выводятся автоматически, а для неуникальных - проверка совпадения категорий
                yield rec


def add_clast_size(key, recs): #добавление размера кластера к каждому ядру
    clast_size = 0
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0:
            clast_size = rec['clast_size']
        else:
            if clast_size != 0:
                rec['clast_size'] = clast_size
                yield rec


def main():
    tab1 = '//home/catalogia/users/yuryz/tmp/bnrs_norm_sense' #см. tf_idf_4.py
    tab2 = '//tmp/yuryz/sem_core'

    yt.run_reduce(sem_core, tab1, tab2, reduce_by = ['mctgs', 'clast_phrase'])
    yt.run_sort(tab2, sort_by=['clast_phrase', 'mctgs'])

    tab3 = '//home/catalogia/users/yuryz/tmp/core_one' #самые частотные ядра из входящих в несколько категорий (см. clast_size_distr_poli.py)
    tab4 = '//tmp/yuryz/sem_core_uniq' #каждое ядро входит ровно в ОДНУ категорию

    yt.run_reduce(uniq, [tab3, tab2], tab4, reduce_by = ['clast_phrase'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    yt.run_sort(tab4, sort_by=['clast_phrase', 'mctgs'])

    tab5 = '//home/catalogia/users/yuryz/tmp/clast_by_phrase'
    tab6 = '//tmp/yuryz/sem_core_clast_size'

    yt.run_reduce(add_clast_size, [tab5, tab4], tab6, reduce_by = ['clast_phrase', 'mctgs'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    yt.run_sort(tab6, sort_by=['clast_phrase', 'mctgs'])

    #--- печать словаря семантических ядер в файл ---
    ctg2id = {} #перекодировочный словарь
    f = open('ctg_list', 'r')
    for line in f:
        line = line.rstrip('\n')
        #ctg, ctg_id = line.decode('utf-8').split('\t')
        ctg, ctg_id = line.split('\t')
        ctg2id[ctg] = ctg_id

    for rec in yt.read_table(tab6, raw=False):
        id = rec['mctgs']
        if rec['mctgs'] in ctg2id:
            id = ctg2id[rec['mctgs']]
        print rec['clast_phrase'] + '\t' + id + '\t' + str(rec['clast_weight']) + '\t' + str(-rec['clast_size'])


if __name__ == '__main__':
    main()
