#!/usr/bin/perl -w
#вычисление коэффициента ранговой корреляции Спирмена 

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';
use Data::Dumper;

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

open F, "wrd_max_tf_idf";
chomp (my @ctg_prof = <F>); #всего 1000 категорий, по 100 слов с max tf_idf на категорию (профиль)

my $N = 100; #число слов в сравниваемых выборках ($N >= 1 && $N <= 100)
my $ro_crit = 0.24; #для N = 100 && p = 0.01

for my $N1 (1..999) {
    print STDERR "$N1\n" if $N1 % 50 == 0;
    my $ro_max = -1;
    my $N2_MAX = $N1+1;
    for my $N2 ($N1+1..1000) {
        my @a = @ctg_prof[($N1-1)*100..($N1-1)*100+($N-1)];
        my @b = @ctg_prof[($N2-1)*100..($N2-1)*100+($N-1)];

        my $ro = spearman(\@a, \@b, $N);
        if ($ro > $ro_max) {
            $ro_max = $ro;
            $N2_MAX = $N2;
        }
    }

    my @t = split /\t/, $ctg_prof[($N1-1)*100]; #0 - категория, 1 - tf_idf, 2 - слово
    my $ctg1 = $t[0];
    @t = split /\t/, $ctg_prof[($N2_MAX-1)*100];
    my $ctg2 = $t[0];

    printf "$N1=$ctg1\t$N2_MAX=$ctg2\t%.3f\n", $ro_max if $ro_max >= $ro_crit;
}


sub spearman {
    my ($a, $b, $N) = @_;

    my (%r1, %r2);
    for my $i (1..$N) {
        my @t = split /\t/, $$a[$i-1]; #0 - категория, 1 - tf_idf, 2 - слово
        $r1{$t[2]} = $i;
        @t = split /\t/, $$b[$i-1];
        $r2{$t[2]} = $i;
    }

    my $D = 0;
    my $END = $N + 1; #для корректировки отсутствующих ключей
    for my $k1 (sort keys %r1) {
        if ($r2{$k1}) {
            $D += ($r1{$k1} - $r2{$k1})**2;
        } else {
            $D += ($r1{$k1} - $END)**2;
            $END++;
        }
    }

    my $ro = 1 - (6 * $D) / ($N * ($N**2 - 1));
    
    return $ro <= -1 ? -1 : $ro;
}
