#!/usr/bin/perl -w
#построение двухсловного индекса для семантических ядер

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';
use Data::Dumper;

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

my $core_prev_1 = "";
my $ind_prev_1 = 0;
my $ind_prev_2 = 0;

my $ind_number = -1; #индекс двусловия в core_index_trunk

my $range_max = -1; #MAX длина диапазона
my $range_avg = 0; #средняя длина диапазона
my $range_num = 0; #число диапазонов

while (<STDIN>) { #core_index_id
    chomp;

    my ($core, $ctg) = split /\t/;
    my @tmp = split / /, $core;
    my $two_word = @tmp > 1 ? "$tmp[0] $tmp[1]" : $tmp[0];

    $ind_number++;

    if ($core_prev_1 eq "") {
        $core_prev_1 = $two_word;
        $ind_prev_1 = $ind_number;
        $ind_prev_2 = $ind_number;
    } elsif($core_prev_1 eq $two_word) {
        $ind_prev_2 = $ind_number;
    } else {
        print "$core_prev_1\t$ind_prev_1\t$ind_prev_2\n"; #формат: <двусловие, индекс_начала, индекс_конца>

        my $range_curr = $ind_prev_2 - $ind_prev_1;
        $range_max = $range_curr if $range_max < $range_curr;
        $range_avg += $range_curr;
        $range_num++;

        $core_prev_1 = $two_word;
        $ind_prev_1 = $ind_number;
        $ind_prev_2 = $ind_number;
    }
}
print "$core_prev_1\t$ind_prev_1\t$ind_prev_2\n";

print STDERR "MAX длина диапазона = $range_max\n";
print STDERR "Число диапазонов = $range_num\n";
printf STDERR "Средняя длина диапазона = %.2f\n", $range_avg / $range_num;
