#!/usr/bin/python
# -*- coding: utf-8 -*-

#формирование статистического профиля категорий на основе лексики с MAX TF-IDF

import yt.wrapper as yt


def add_minus(rec): #вставка минуса перед TF-IDF для упорядочивания по возрастанию
    tf_idf = float('%.3f' % (-10000 * rec['tf_idf']))
    yield { "mctgs": rec['mctgs'], "tf_idf": tf_idf, "word": rec['word'] }


TOP = 100 #количество слов, определяющих статистический профиль категории

def word_top(key, recs): #выбор слов с максимальными значениями TF_IDF для категорий
    count = 0
    for rec in recs:
        count += 1
        if count > TOP:
            break
        yield rec


def main():
    tab1 = '//home/catalogia/users/yuryz/tmp/wrd_ctg_tf_idf'
    tab2 = '//tmp/yuryz/wrd_ctg_tf_idf'

    #yt.run_map(add_minus, tab1, tab2)
    #yt.run_sort(tab2, sort_by=['mctgs', 'tf_idf', 'word'])

    tab3 = '//home/catalogia/users/yuryz/tmp/word_prof_of_ctg'

    #yt.run_reduce(word_top, tab2, tab3, reduce_by = ['mctgs'])
    #yt.run_sort(tab3, sort_by=['mctgs', 'tf_idf', 'word'])

    #print yt.row_count(tab1)
    #print yt.row_count(tab2)
    #print yt.row_count(tab3)

    for rec in yt.read_table(tab3, raw=False):
        print  rec['mctgs'] + '\t' + str(rec['tf_idf']) + '\t' + rec['word']


if __name__ == '__main__':
    main()
