#!/usr/bin/perl -w
#вычисление коэффициента ранговой корреляции Спирмена между статистическими (TF-IDF) профилями категорий
#критическое значение ro=0.25 для p=0.01

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';
use Data::Dumper;

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

select(STDOUT); $| = 1; # отключаем буферизацию

my %ctg_prof;
open F, "word_prof_of_ctg";
while (<F>) {
    chomp;
    my ($ctg, $tf_idf, $word) = split /\t/;
    push @{$ctg_prof{$ctg}}, $word; #хеш массивов (для каждой категории - список топовых слов)
}

my @ctg = sort keys %ctg_prof;
for my $i (0..$#ctg-1) {
    my $a = $ctg_prof{$ctg[$i]}; #список слов для i-й категории
    for my $j ($i+1..$#ctg) {
        my $b = $ctg_prof{$ctg[$j]};
        my $N = @$a <= @$b ? @$a : @$b;
        my $ro = sprintf "%.2f", spearman($a, $b, $N);
        print "$ctg[$i] (", @$a+0, ")\t$ctg[$j] (", @$b+0, ")\t$N\t$ro\n" if $ro > 0.25;
    }
}


# --- ранговый коэффициент Спирмена ---
sub spearman {
    my ($a, $b, $N) = @_;

    return $$a[0] eq $$b[0] ? 1 : -1 if $N == 1;

    my (%r1, %r2);
    for my $i (1..$N) {
        $r1{$$a[$i-1]} = $i; #ранг ядра $$a[$i-1]
        $r2{$$b[$i-1]} = $i;
    }

    my $D = 0;
    my $END = $N + 1; #для корректировки отсутствующих ключей
    for my $k1 (sort keys %r1) {
        if ($r2{$k1}) {
            $D += ($r1{$k1} - $r2{$k1})**2;
        } else {
            $D += ($r1{$k1} - $END)**2;
            $END++;
        }
    }

    my $ro = 1 - (6 * $D) / ($N * ($N**2 - 1));
    
    return $ro <= -1 ? -1 : $ro;
}
