#!/usr/bin/python
# -*- coding: utf-8 -*-

#кластеризация баннеров с помощью расстояния Левенштейна

import re
import yt.wrapper as yt


def bid(rec):
    yield { "bid" : rec['bid'] }


def compr(key, recs): #сжатие дублей
    rec = next(recs)
    yield rec


def main():
    #tab1 = '//tmp/yuryz/clast1_exp'
    tab1 = '//tmp/yuryz/clast2_exp'
    tab2 = '//tmp/yuryz/tmp_bid'

    print "ВЫВОД BID"
    yt.run_map(bid, tab1, tab2)
    yt.run_sort(tab2, sort_by=['bid'])

    tab3 = '//tmp/yuryz/tmp_uniq'

    print "УДАЛЕНИЕ ДУБЛЕЙ"
    yt.run_reduce(compr, tab2, tab3, reduce_by = ['bid']) #сжатие дублей

    print yt.row_count(tab2)
    print yt.row_count(tab3)

    yt.remove(tab2)
    yt.remove(tab3)


if __name__ == '__main__':
    main()
