#!/usr/bin/python
# -*- coding: utf-8 -*-

#удаление кластеров определенных (обычно небольших) размеров

import yt.wrapper as yt

MAX_SIZE = 100 #максимальный размер удаляемого кластера


def reducer(key, recs):
    L = []
    flag = 0
    count = 0
    for rec in recs:
        count += 1
        if count <= MAX_SIZE: #запоминаем до достижения порогового значения
            L.append(rec)
        else:
            if flag == 0:
                flag = 1
                for row in L:
                    yield row
            yield rec


def main():
    tab1 = '//home/catalogia/users/yuryz/virt/virt_pref_comb'
    tab2 = '//home/catalogia/users/yuryz/virt/virt_pref_clast1'

    yt.run_reduce(reducer, [tab1], [tab2], reduce_by = ['comb'])
    yt.run_sort(tab2, tab2, sort_by=['comb', 'mctgs', 'bid'])

    print yt.row_count(tab1)
    print yt.row_count(tab2)


if __name__ == '__main__':
    main()
