#!/usr/bin/python
# -*- coding: utf-8 -*-

#оценка качества монотематических кластеров

import yt.wrapper as yt

SIZE_MIN = 0.10

def reducer(key, recs):
    flag = 0
    for rec in recs:
        if flag == 0:
            flag = 1
            size_max = float(rec['size'])

        rank = '%.3f' % (rec['size'] / size_max)
        if rank <= -SIZE_MIN:
            rec['rank'] = rank
            yield rec


def main():
    tab1 = '//home/catalogia/users/yuryz/virt/clast_ctgs_mono'
    tab2 = '//home/catalogia/users/yuryz/virt/clast_mono_rank'

    yt.run_reduce(reducer, [tab1], [tab2], reduce_by = ['mctgs'])
    yt.run_sort(tab2, tab2, sort_by=['mctgs', 'comb', 'rank', 'size'])

    print yt.row_count(tab1)
    print yt.row_count(tab2)


if __name__ == '__main__':
    main()
