#!/usr/bin/python
# -*- coding: utf-8 -*-

#статистика числа кластеров внутри категорий (может пригодиться при укрупнении кластеров)

import yt.wrapper as yt


def reducer(key, recs):
    count = 0
    for rec in recs:
        count += 1
    yield { "mctgs": key['mctgs'], "clast_count": -count }

def main():
    tab1 = '//home/catalogia/users/yuryz/virt/comb_compr_rank_u'
    tab2 = '//tmp/yuryz/ctgs_clast_count'

    yt.run_reduce(reducer, [tab1], [tab2], reduce_by = ['mctgs'])
    yt.run_sort(tab2, sort_by=['clast_count', 'mctgs'])

    print yt.row_count(tab1)
    print yt.row_count(tab2)


if __name__ == '__main__':
    main()
