#!/usr/bin/python
# -*- coding: utf-8 -*-

#Второй этап определения покрытия категорий Каталогии кластерами (добавление поля bid)

import yt.wrapper as yt


def reducer(key, recs):
    comb = ""
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0:
            comb = key['comb']
            mctgs = key['mctgs']
        else:
            if comb != "":
                yield { "mctgs": mctgs, "bid": rec['bid'] }

def main():
    tab1 = '//home/catalogia/users/yuryz/virt/cover1'
    tab2 = '//home/catalogia/users/yuryz/virt/virt_pref_comb'
    tab3 = '//home/catalogia/users/yuryz/virt/cover2'

    yt.run_reduce(reducer, [tab1, tab2], [tab3], reduce_by = ['comb', 'mctgs'])
    yt.run_sort(tab3, sort_by=['mctgs', 'bid'])

    print yt.row_count(tab1)
    print yt.row_count(tab2)
    print yt.row_count(tab3)


if __name__ == '__main__':
    main()
