#!/usr/bin/perl -w
#вычисление доли плохих категорий во входном потоке

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';
use Data::Dumper;

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

my %ctgs_freq;
open F, "ctgs_freq";
while (<F>) {
    chomp;
    my ($freq, $ctg, $freq_rel) = split /\t/;
    $ctgs_freq{$ctg} = $freq;
}

open F, "ctgs_good_100";
my $total = 0;
while (<F>) {
    chomp;
    my ($ctg, @rest) = split /\t/;
    $total += $ctgs_freq{$ctg};
}

open F, "ctgs_bad_100";
my $bad = 0;
while (<F>) {
    chomp;
    my ($ctg, @rest) = split /\t/;
    $total += $ctgs_freq{$ctg};
    $bad += $ctgs_freq{$ctg};
}

print "TOTAL=$total\n";
print "BAD=$bad\n";
printf "BAD_FRACTION=%.3f\n", $bad / $total;
