#!/usr/bin/perl -w
#корректировка списков "хороших"/"плохих" категорий

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';
use Data::Dumper;

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

my %cor;
if (open F, "ctgs_corr") { #корректирующий список
    while (<F>) {
        chomp;
        my @a = split /\t/;
        if ($a[0] =~ /^\./) {
            $cor{substr($a[0], 1)} = 'b'; #точку удаляем
        } else {
            $cor{$a[0]} = 'g';
        }
    }
}

open F, "ctgs_good_100";
chomp(my @god = <F>);

open F, "ctgs_bad_100";
chomp(my @bad = <F>);

my @tmp;
for my $i (0..$#god) {
    my @a = split /\t/, $god[$i];
    if ($cor{$a[0]} && $cor{$a[0]} eq 'b') {
        push @bad, $god[$i];
    } else {
        push @tmp, $god[$i];
    }
}
@god = @tmp;

@tmp = ();
for my $i (0..$#bad) {
    my @a = split /\t/, $bad[$i];
    if ($cor{$a[0]} && $cor{$a[0]} eq 'g') {
        push @god, $bad[$i];
    } else {
        push @tmp, $bad[$i];
    }
}
@bad = @tmp;

@god = sort @god;
@bad = sort @bad;

open F, ">ctgs_good_100";
print F "$_\n" for @god;

open F, ">ctgs_bad_100";
print F "$_\n" for @bad;
