#!/usr/bin/perl -w
#обнаружение плохих категорий на основе частот двусловных шинглов

use strict;
use Encode;
use utf8;
use open ':utf8';
no warnings 'utf8';
use Data::Dumper;

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

my $pref = decode_utf8($ARGV[0]); #из внутреннего

open F, "virt_pref_bnrs";
my @bnrs;
while (<F>) {
    chomp;
    next unless /^\.?$pref/;
    push @bnrs, $_;
}

my %sh_ctgs; #частотный словарь шинглов всех виртуальных категорий с одинаковым префиксом
my %sh_bnrs; #частотный словарь шинглов отдельный баннеров
for (@bnrs) {
    chomp;

    my ($ctg, $bid, $title, $body) = split /\t/;
    my $bnr = $title =~ /[a-zа-яё]$/ && $body =~ /^[a-zа-яё]/ ? "$title $body" : "$title\t$body";
    my @a = sent_div($bnr); #список предложений баннера

    for my $a (@a) {
        next unless $a;
        my @b = split /(?<![0-9])[,;:](?![0-9])| - /, $a; #список смысловых фрагментов предложения
        for my $b (@b) {
            $b = lc($b);
            $b =~ s/[^a-zа-яё0-9%.]/ /g;

            $b =~ s/^ +//;
            $b =~ s/ +$//;
            $b =~ s/  +/ /g;

            my @sh = split / /, $b; #список шинглов смыслового фрагмента
            if (@sh > 1) {
                for my $i (0..$#sh-1) {
                    $sh_ctgs{"$sh[$i] $sh[$i+1]"}++;
                    $sh_bnrs{$bid}{"$sh[$i] $sh[$i+1]"}++;
                }
            } elsif (@sh == 1) {
                $sh_ctgs{$sh[0]}++;
                $sh_bnrs{$bid}{$sh[0]}++;
            }
        }
    }
}


for (@bnrs) {
    chomp;

    my ($ctg, $bid, $title, $body) = split /\t/;
    my $rank = 0;
    for my $sh (keys %{$sh_bnrs{$bid}}) { #шинглы баннера
        $rank += $sh_bnrs{$bid}{$sh} * $sh_ctgs{$sh};
    }
    $rank = sprintf("%.3f", $rank / scalar(keys %{$sh_bnrs{$bid}})); #средний ранг на 1 шингл
    print "$rank\t$_\n";
}


#--- разделение на предложения ---
sub sent_div {
    return split /(?<!\.[A-ZА-ЯЁ0-9])[.!?\t]+?\s*?(?=[A-ZА-ЯЁ0-9][^.]|$)/, shift;
}
