#!/usr/bin/perl -w
#получение первичного списка баннеров для малочастотных категорий

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';
use Data::Dumper;

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

my %ctg2id;
open F, "ctg2id";
while (<F>) {
    chomp;
    my @a = split /\t/; #0 - ctg, 1 - ctg_id
    $ctg2id{$a[0]} = $a[1];
}

my $TOT = 200000000; #число баннеров для обработки

my $t1 = localtime;

my $cnt = 0;
while (<STDIN>) { #zcat /opt/broadmatching/work/direct_client/banners_extended.gz
    chomp;
    my @a = split /\t/; #0 - bid, 1 - campaign_id, 3 - title, 4 - body, 20 - categs (mctgs=Защита автомобиля от внешних воздействий/Кабельные каналы, короба, перфорированные короба)

    my $ctgs = substr($a[20], 6);
    my @ctgs = split m{/}, $ctgs; #омонимичный баннер
    next if @ctgs != 1; #####

    if ($ctg2id{$ctgs[0]}) {
        my $ctg_id = $ctg2id{$ctgs[0]};
        my $h = hash("$a[3]\t$a[4]", 1000000000);
        print "$a[0]\t$ctg_id\t$h\n"; #bid, ctg_id, hash
        last if ++$cnt == $TOT;
    }
}

my $t2 = localtime;
print STDERR scalar($t1), "\n";
print STDERR scalar($t2), "\n";


#--- хеш-функция ---
sub hash {
    my ($v, $M) = @_; #v - текст, M - величина диапазона

    my $a = 127; #простое число
    my $h = 0; #собственно хеш
    $h = ($a * $h + ord($_)) % $M for split //, $v;

    return $h;
}
