#!/usr/bin/perl -w
#определяет ближайший баннер, относительный ранг которого >= заданной величины

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';
use Data::Dumper;

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

my $MIN_RANK = 0.65; #минимальный ОТНОСИТЕЛЬНЫЙ (0..1) ранг баннера
my $MIN_FREQ = 100; #минимальное число баннеров категории в выборке

my %ctgs_bad = (
    "Русский язык" => 1,
    "Опт _ Автомобили" => 1,
    "#ЕГЭ" => 1,
    "Монтаж _ Системы вентиляции и кондиционирования" => 1,
    "Запчасти к электростанциям" => 1,
    "Гидроэлектростанции и гидроэнергетическое оборудование" => 1,
    "За рубежом _ Аборт" => 1,
);

my %id2ctg;
open F, "ctgs_freq";
while (<F>) {
    chomp;
    my @a = split /\t/; #0 - ctg, 1 - ctg_id, 2 - freq
    $id2ctg{$a[1]} = [ $a[0], $a[2] ];
}

my $rank_prev = -1;
my $rec_prev;
print "bid\ttitle\tbody\touter_category\n"; #заголовки столбцов таблицы
while (<STDIN>) { #bnr_text_rank_p
    chomp;

    my ($bid, $title, $body, $ctg_id, $rank, $rank_rel) = split /\t/;
    next if $ctgs_bad{${$id2ctg{$ctg_id}}[0]};
    next if ${$id2ctg{$ctg_id}}[1] < $MIN_FREQ;

    next if ${$id2ctg{$ctg_id}}[0] eq "Гостиницы России" && "$title $body" =~ /Украин/;
    next if ${$id2ctg{$ctg_id}}[0] eq "Рассчетно-кассовое обслуживание" && "$title $body" !~ /(ООО|ИП)/;

    if ($rank_prev != -1) {
        if ($rank_prev >= $MIN_RANK) {
            if ($rank_rel < $MIN_RANK) {
                my ($bid_prev, $title_prev, $body_prev, $ctg_id_prev, $rank_prev, $rank_rel_prev) = split /\t/, $rec_prev;
                print "$bid_prev\t$title_prev\t$body_prev\t${$id2ctg{$ctg_id_prev}}[0]\n";
            }
        }
    }

    $rank_prev = $rank_rel;
    $rec_prev = $_;
}
