#!/usr/bin/perl -w
#получение эталонной выборки

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';
use Data::Dumper;

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

my $MIN_RANK = 0.65; #минимальный ОТНОСИТЕЛЬНЫЙ (0..1) ранг баннера
my $MIN_FREQ = 200; #минимальное число баннеров категории в выборке

my %ctgs_bad = (
    "Русский язык" => 1,
    "Опт _ Автомобили" => 1,
    "#ЕГЭ" => 1,
    "Монтаж _ Системы вентиляции и кондиционирования" => 1,
    "Запчасти к электростанциям" => 1,
    "Гидроэлектростанции и гидроэнергетическое оборудование" => 1,
    "За рубежом _ Аборт" => 1,
);

my %id2ctg;
open F, $ARGV[0];
while (<F>) {
    chomp;
    my @a = split /\t/; #0 - ctg, 1 - ctg_id, 2 - freq
    $id2ctg{$a[1]} = [ $a[0], $a[2] ];
}

my $cnt = 0;
my $bnr_cnt = 0;
while (<STDIN>) { #bnr_text_rank_p
    chomp;

    my ($bid, $title, $body, $ctg_id, $rank, $rank_rel) = split /\t/;
    print STDERR "$cnt\t$ctg_id\n" if ++$cnt % 10000 == 0; #ProgressBar

    next if $ctgs_bad{${$id2ctg{$ctg_id}}[0]};
    next if ${$id2ctg{$ctg_id}}[1] < $MIN_FREQ;
    next if $rank_rel < $MIN_RANK;

    next if ${$id2ctg{$ctg_id}}[0] eq "Гостиницы России" && "$title $body" =~ /Украин/;
    next if ${$id2ctg{$ctg_id}}[0] eq "Рассчетно-кассовое обслуживание" && "$title $body" !~ /(ООО|ИП)/;

    #print "$bid\t$title\t$body\t${$id2ctg{$ctg_id}}[0]\n";
    print "$bid\n"; #для YT
    $bnr_cnt++;
}
#print  "*$bnr_cnt\n";
