#!/usr/bin/python
# -*- coding: utf-8 -*-

#добавление "смыслового ядра" баннера к таблице префиксов

import yt.wrapper as yt


def reducer(key, recs):
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0:
            bnorm = rec['bnorm']
        else:
            rec['bnorm'] = bnorm
            yield rec


def main():
    input_1 = '//home/catalogia/users/yuryz/bnrs_norm'
    input_2 = '//home/catalogia/users/yuryz/virt/virt_pref'
    output = '//home/catalogia/users/yuryz/virt/virt_pref_norm'

    yt.run_reduce(reducer, [input_1, input_2], output, reduce_by = 'bid')
    #yt.run_sort(output, sort_by=['virt_pref', 'mctgs', 'rank_rel', 'bid'])
    yt.run_sort(output, sort_by=['virt_pref', 'mctgs', 'bid'])

    print yt.row_count(input_1)
    print yt.row_count(input_2)
    print yt.row_count(output)


if __name__ == '__main__':
    main()
