#!/usr/bin/python
# -*- coding: utf-8 -*-

import yt.wrapper as yt


def reducer(key, recs):
    cnt = 0
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0:
            cnt = 1
        else:
            if cnt == 1:
                yield rec


def main():
    input_1 = '//home/catalogia/users/yuryz/bid_model_065_200_s'
    input_2 = '//home/catalogia/banners_extended'
    output = '//home/catalogia/users/yuryz/bnrs_model_065_200'

    yt.run_reduce(reducer, [input_1, input_2], output, reduce_by = 'bid')
    yt.run_sort(output, sort_by=['bid'])

    print yt.row_count(input_1)
    print yt.row_count(input_2)
    print yt.row_count(output)


if __name__ == '__main__':
    main()
